/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli;

import java.io.File;
import java.lang.reflect.Constructor;
import org.jetbrains.jet.compiler.CompilerPlugin;

public class KDocLoader {
    private final String outputDir;

    public KDocLoader(String outputDir) {
        this.outputDir = outputDir;
    }

    public CompilerPlugin createCompilerPlugin() {
        String name = "org.jetbrains.kotlin.doc.KDoc";
        Class<?> aClass = null;
        try {
            aClass = KDocLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Could not find class: " + name);
            return null;
        }
        if (aClass != null) {
            try {
                File dir = new File(this.outputDir);
                Constructor<?> constructor = aClass.getConstructor(File.class);
                if (constructor != null) {
                    return (CompilerPlugin)constructor.newInstance(dir);
                }
            }
            catch (Exception e) {
                System.out.println("Failed to create Processor: " + e);
            }
        }
        return null;
    }

    public static Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e1) {
                return KDocLoader.class.getClassLoader().loadClass(name);
            }
        }
    }
}

