/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.SeparatorComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class FormBuilder {
    private static final boolean ALIGN_LABELS_TO_RIGHT = UIUtil.isUnderAquaLookAndFeel();
    private int line = 0;
    private int indent;
    private final JPanel panel;
    private boolean vertical;

    public FormBuilder(boolean vertical, int indent) {
        this.vertical = vertical;
        this.panel = new JPanel(new GridBagLayout());
        this.indent = indent;
    }

    public FormBuilder(boolean vertical) {
        this(vertical, 5);
    }

    public FormBuilder() {
        this(false, 5);
    }

    public FormBuilder addLabeledComponent(String labelText, JComponent component, int verticalSpace) {
        return this.addLabeledComponent(labelText, component, verticalSpace, false);
    }

    public FormBuilder addLabeledComponent(String labelText, JComponent component, int verticalSpace, boolean labelOnTop) {
        JLabel label = null;
        if (labelText != null) {
            label = new JLabel(UIUtil.removeMnemonic(labelText));
            int index = UIUtil.getDisplayMnemonicIndex(labelText);
            if (index != -1) {
                label.setDisplayedMnemonic(labelText.charAt(index + 1));
            }
            label.setLabelFor(component);
        }
        return this.addLabelAndValueComponents(label, component, verticalSpace, false, labelOnTop);
    }

    public FormBuilder addLabeledComponent(String labelText, JComponent component) {
        return this.addLabeledComponent(labelText, component, 10);
    }

    public FormBuilder addLabeledComponent(String labelText, JComponent component, boolean labelOnTop) {
        return this.addLabeledComponent(labelText, component, 10, labelOnTop);
    }

    public FormBuilder addSeparator(int verticalSpace) {
        return this.addLabelAndValueComponents(new SeparatorComponent(3, 0), new SeparatorComponent(3, 0), verticalSpace, true, false);
    }

    public FormBuilder addSeparator() {
        return this.addSeparator(10);
    }

    private FormBuilder addLabelAndValueComponents(@Nullable JComponent label, JComponent value, int verticalSpace, boolean fillLabel, boolean labelOnTop) {
        int verticalInset;
        GridBagConstraints c = new GridBagConstraints();
        int n = verticalInset = this.line > 0 ? verticalSpace : 0;
        if (this.vertical) {
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = this.line;
            c.weightx = 1.0;
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(verticalInset, 0, this.indent, 0);
            if (label != null) {
                this.panel.add((Component)label, c);
            }
            c.gridx = 0;
            c.gridy = this.line + 1;
            c.weightx = 1.0;
            c.fill = value instanceof JComboBox ? 0 : 2;
            c.anchor = 17;
            c.insets = new Insets(0, 0, 0, this.indent);
            this.panel.add((Component)value, c);
            this.line += 2;
        } else {
            c.gridx = 0;
            c.gridy = this.line;
            c.weightx = 0.0;
            c.anchor = ALIGN_LABELS_TO_RIGHT ? (labelOnTop ? 12 : 13) : (labelOnTop ? 18 : 17);
            c.insets = new Insets(verticalInset, 0, 0, fillLabel ? 0 : this.indent);
            if (fillLabel) {
                c.fill = 2;
            }
            if (label != null) {
                this.panel.add((Component)label, c);
            }
            c.gridx = 1;
            c.gridy = this.line;
            c.fill = value instanceof JComboBox ? 0 : 2;
            c.anchor = 17;
            c.weightx = 1.0;
            c.insets = new Insets(verticalInset, 0, 0, 0);
            this.panel.add((Component)value, c);
            ++this.line;
        }
        return this;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public int getLine() {
        return this.line;
    }
}

