/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Topic<L> {
    private final String myDisplayName;
    private final Class<L> myListenerClass;
    private final BroadcastDirection myBroadcastDirection;

    public Topic(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass) {
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/messages/Topic.<init> must not be null");
        }
        if (listenerClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/messages/Topic.<init> must not be null");
        }
        this(displayName, listenerClass, BroadcastDirection.TO_CHILDREN);
    }

    public Topic(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass, BroadcastDirection broadcastDirection) {
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/messages/Topic.<init> must not be null");
        }
        if (listenerClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/messages/Topic.<init> must not be null");
        }
        this.myDisplayName = displayName;
        this.myListenerClass = listenerClass;
        this.myBroadcastDirection = broadcastDirection;
    }

    @NotNull
    @NonNls
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/messages/Topic.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public Class<L> getListenerClass() {
        Class<L> clazz = this.myListenerClass;
        if (clazz == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/messages/Topic.getListenerClass must not return null");
        }
        return clazz;
    }

    public String toString() {
        return this.myDisplayName;
    }

    public static <L> Topic<L> create(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass) {
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/messages/Topic.create must not be null");
        }
        if (listenerClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/messages/Topic.create must not be null");
        }
        return new Topic<L>(displayName, listenerClass);
    }

    public static <L> Topic<L> create(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass, BroadcastDirection direction) {
        if (displayName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/messages/Topic.create must not be null");
        }
        if (listenerClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/messages/Topic.create must not be null");
        }
        return new Topic<L>(displayName, listenerClass, direction);
    }

    public BroadcastDirection getBroadcastDirection() {
        return this.myBroadcastDirection;
    }

    public static enum BroadcastDirection {
        TO_CHILDREN,
        NONE,
        TO_PARENT;

    }
}

