/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class UnsyncByteArrayOutputStream
extends OutputStream {
    protected byte[] myBuffer;
    protected int myCount;

    public UnsyncByteArrayOutputStream() {
        this(32);
    }

    public UnsyncByteArrayOutputStream(int size) {
        this.myBuffer = new byte[size];
    }

    @Override
    public void write(int b) {
        int newcount = this.myCount + 1;
        if (newcount > this.myBuffer.length) {
            this.myBuffer = Arrays.copyOf(this.myBuffer, Math.max(this.myBuffer.length << 1, newcount));
        }
        this.myBuffer[this.myCount] = (byte)b;
        this.myCount = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.myCount + len;
        if (newcount > this.myBuffer.length) {
            this.myBuffer = Arrays.copyOf(this.myBuffer, Math.max(this.myBuffer.length << 1, newcount));
        }
        System.arraycopy(b, off, this.myBuffer, this.myCount, len);
        this.myCount = newcount;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.myBuffer, 0, this.myCount);
    }

    public void reset() {
        this.myCount = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.myBuffer, this.myCount);
    }

    public int size() {
        return this.myCount;
    }

    public String toString() {
        return new String(this.myBuffer, 0, this.myCount);
    }
}

