/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SafeFileOutputStream
extends OutputStream {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.SafeFileOutputStream");
    private static final String EXTENSION_BAK = "___jb_bak___";
    private static final String EXTENSION_OLD = "___jb_old___";
    private final File myTargetFile;
    private final boolean myPreserveAttributes;
    private final File myBackDoorFile;
    private final OutputStream myBackDoorStream;
    private boolean failed = false;

    public SafeFileOutputStream(File target) throws FileNotFoundException {
        this(target, false);
    }

    public SafeFileOutputStream(File target, boolean preserveAttributes) throws FileNotFoundException {
        this.myTargetFile = target;
        this.myPreserveAttributes = preserveAttributes;
        this.myBackDoorFile = new File(this.myTargetFile.getParentFile(), this.myTargetFile.getName() + EXTENSION_BAK);
        this.myBackDoorStream = new FileOutputStream(this.myBackDoorFile);
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.myBackDoorStream.write(b);
        }
        catch (IOException e) {
            LOG.warn(e);
            this.failed = true;
            throw e;
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.myBackDoorStream.write(b);
        }
        catch (IOException e) {
            LOG.warn(e);
            this.failed = true;
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.myBackDoorStream.write(b, off, len);
        }
        catch (IOException e) {
            LOG.warn(e);
            this.failed = true;
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.myBackDoorStream.flush();
        }
        catch (IOException e) {
            LOG.warn(e);
            this.failed = true;
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.myBackDoorStream.close();
        }
        catch (IOException e) {
            LOG.warn(e);
            FileUtil.delete(this.myBackDoorFile);
            throw e;
        }
        if (this.failed) {
            throw new IOException(CommonBundle.message("safe.write.failed", this.myTargetFile, this.myBackDoorFile.getName()));
        }
        int permissions = this.myPreserveAttributes ? FileSystemUtil.getPermissions(this.myTargetFile) : -1;
        File oldFile = new File(this.myTargetFile.getParent(), this.myTargetFile.getName() + EXTENSION_OLD);
        try {
            FileUtil.rename(this.myTargetFile, oldFile);
        }
        catch (IOException e) {
            LOG.warn(e);
            throw new IOException(CommonBundle.message("safe.write.rename.original", this.myTargetFile, this.myBackDoorFile.getName()));
        }
        try {
            FileUtil.rename(this.myBackDoorFile, this.myTargetFile);
        }
        catch (IOException e) {
            LOG.warn(e);
            throw new IOException(CommonBundle.message("safe.write.rename.backup", this.myTargetFile, oldFile.getName(), this.myBackDoorFile.getName()));
        }
        if (permissions != -1) {
            FileSystemUtil.setPermissions(this.myTargetFile, permissions);
        }
        if (!FileUtil.delete(oldFile)) {
            throw new IOException(CommonBundle.message("safe.write.drop.temp", oldFile));
        }
    }
}

