/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.ConcurrentSLRUMap;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import java.io.File;
import java.io.IOException;

public class PersistentStringEnumerator
extends PersistentEnumeratorDelegate<String> {
    private final ConcurrentSLRUMap<Integer, String> myIdToStringCache;
    private final ConcurrentSLRUMap<Integer, Integer> myHashcodeToIdCache;

    public PersistentStringEnumerator(File file) throws IOException {
        this(file, 4096);
    }

    public PersistentStringEnumerator(File file, boolean cacheLastMappings) throws IOException {
        this(file, 4096, cacheLastMappings);
    }

    public PersistentStringEnumerator(File file, int initialSize) throws IOException {
        this(file, initialSize, false);
    }

    private PersistentStringEnumerator(File file, int initialSize, boolean cacheLastMappings) throws IOException {
        super(file, new EnumeratorStringDescriptor(), initialSize);
        if (cacheLastMappings) {
            this.myIdToStringCache = new ConcurrentSLRUMap(8192, 8192);
            this.myHashcodeToIdCache = new ConcurrentSLRUMap(8192, 8192);
        } else {
            this.myIdToStringCache = null;
            this.myHashcodeToIdCache = null;
        }
    }

    @Override
    public int enumerate(String value) throws IOException {
        String s;
        Integer cachedId;
        int valueHashCode = -1;
        if (this.myHashcodeToIdCache != null && value != null && (cachedId = this.myHashcodeToIdCache.get(valueHashCode = value.hashCode())) != null && (s = this.myIdToStringCache.get((int)cachedId)) != null && value.equals(s)) {
            return cachedId;
        }
        int enumerate = super.enumerate(value);
        if (this.myHashcodeToIdCache != null && value != null) {
            this.myHashcodeToIdCache.put(valueHashCode, enumerate);
        }
        if (this.myIdToStringCache != null) {
            this.myIdToStringCache.put(enumerate, value);
        }
        return enumerate;
    }

    @Override
    public String valueOf(int idx) throws IOException {
        String s;
        if (this.myIdToStringCache != null && (s = this.myIdToStringCache.get(idx)) != null) {
            return s;
        }
        s = (String)super.valueOf(idx);
        if (this.myIdToStringCache != null && s != null) {
            this.myIdToStringCache.put(idx, s);
        }
        return s;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.myIdToStringCache != null) {
            this.myIdToStringCache.clear();
        }
        if (this.myHashcodeToIdCache != null) {
            this.myHashcodeToIdCache.clear();
        }
    }

    public void markCorrupted() {
        this.myEnumerator.markCorrupted();
    }
}

