/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.Bits;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.ResizeableMappedFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PersistentEnumerator<Data>
extends PersistentEnumeratorBase<Data> {
    private static final int DIRTY_MAGIC = -1161951863;
    private static final int VERSION = 6;
    private static final int CORRECTLY_CLOSED_MAGIC = -341069902;
    private static final int FIRST_VECTOR_OFFSET = 20;
    private static final int BITS_PER_LEVEL = 4;
    private static final int SLOTS_PER_VECTOR = 16;
    private static final int LEVEL_MASK = 15;
    private static final byte[] EMPTY_VECTOR = new byte[64];
    private static final int BITS_PER_FIRST_LEVEL = 12;
    private static final int SLOTS_PER_FIRST_VECTOR = 4096;
    private static final int FIRST_LEVEL_MASK = 4095;
    private static final byte[] FIRST_VECTOR = new byte[16384];
    private static final int COLLISION_OFFSET = 0;
    private static final int KEY_HASHCODE_OFFSET = 4;
    private static final int KEY_REF_OFFSET = 8;
    private static final int RECORD_SIZE = 12;
    private int valuesCount;
    private static final PersistentEnumeratorBase.Version ourVersion = new PersistentEnumeratorBase.Version(-341069902, -1161951863);

    public PersistentEnumerator(File file, KeyDescriptor<Data> dataDescriptor, int initialSize) throws IOException {
        super(file, new ResizeableMappedFile(file, initialSize, ourLock), dataDescriptor, initialSize, ourVersion, new RecordBufferHandler(), true);
    }

    @Override
    protected void setupEmptyFile() throws IOException {
        this.allocVector(FIRST_VECTOR);
    }

    @Override
    public synchronized boolean traverseAllRecords(PersistentEnumeratorBase.RecordsProcessor p) throws IOException {
        return this.traverseRecords(20, 4096, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean traverseRecords(int vectorStart, int slotsCount, PersistentEnumeratorBase.RecordsProcessor p) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            for (int slotIdx = 0; slotIdx < slotsCount; ++slotIdx) {
                int vector = this.myStorage.getInt(vectorStart + slotIdx * 4);
                if (vector < 0) {
                    int record = -vector;
                    while (record != 0) {
                        if (!p.process(record)) {
                            return false;
                        }
                        record = this.nextCanditate(record);
                    }
                    continue;
                }
                if (vector <= 0 || this.traverseRecords(vector, 16, p)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized int enumerateImpl(Data value, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            int newId;
            block12: {
                int candidateHC;
                int pos;
                int lastVector;
                int valueHC;
                int depth = 0;
                int hc = valueHC = this.myDataDescriptor.getHashCode(value);
                int vector = 20;
                int levelMask = 4095;
                int bitsPerLevel = 12;
                do {
                    lastVector = vector;
                    pos = vector + (hc & levelMask) * 4;
                    hc >>>= bitsPerLevel;
                    vector = this.myStorage.getInt(pos);
                    ++depth;
                    levelMask = 15;
                    bitsPerLevel = 4;
                } while (vector > 0);
                if (vector == 0) {
                    if (onlyCheckForExisting) {
                        return 0;
                    }
                    int newId2 = this.writeData(value, valueHC);
                    this.myStorage.putInt(pos, -newId2);
                    return newId2;
                }
                int collision = -vector;
                boolean splitVector = false;
                do {
                    if ((candidateHC = this.hashCodeOf(collision)) != valueHC) {
                        splitVector = true;
                        break;
                    }
                    Object candidate = this.valueOf(collision);
                    if (!this.myDataDescriptor.isEqual(value, candidate)) continue;
                    return collision;
                } while ((collision = this.nextCanditate(collision)) != 0);
                if (onlyCheckForExisting) {
                    return 0;
                }
                newId = this.writeData(value, valueHC);
                if (splitVector) {
                    --depth;
                    while (true) {
                        int oldHCByte;
                        int valueHCByte;
                        if ((valueHCByte = PersistentEnumerator.hcByte(valueHC, depth)) != (oldHCByte = PersistentEnumerator.hcByte(candidateHC, depth))) {
                            this.myStorage.putInt(lastVector + valueHCByte * 4, -newId);
                            this.myStorage.putInt(lastVector + oldHCByte * 4, vector);
                            break block12;
                        }
                        int newVector = this.allocVector(EMPTY_VECTOR);
                        this.myStorage.putInt(lastVector + oldHCByte * 4, newVector);
                        lastVector = newVector;
                        ++depth;
                    }
                }
                this.myStorage.putInt(newId, vector);
                this.myStorage.putInt(pos, -newId);
            }
            return newId;
        }
    }

    @Override
    protected int writeData(Data value, int hashCode) {
        int id = super.writeData(value, hashCode);
        ++this.valuesCount;
        if (this.valuesCount % 50000 == 0 && IOStatistics.DEBUG) {
            IOStatistics.dump("Index " + this.myFile + ", values " + this.valuesCount + ", storage size:" + this.myStorage.length());
        }
        return id;
    }

    private static int hcByte(int hashcode, int byteN) {
        if (byteN == 0) {
            return hashcode & 0xFFF;
        }
        return (hashcode >>>= 12) >>> --byteN * 4 & 0xF;
    }

    private int allocVector(byte[] empty) throws IOException {
        int pos = (int)this.myStorage.length();
        this.myStorage.put(pos, empty, 0, empty.length);
        return pos;
    }

    private int nextCanditate(int idx) throws IOException {
        return -this.myStorage.getInt(idx);
    }

    private int hashCodeOf(int idx) throws IOException {
        return this.myStorage.getInt(idx + 4);
    }

    @Override
    protected int indexToAddr(int idx) {
        return this.myStorage.getInt(idx + 8);
    }

    private static class RecordBufferHandler
    extends PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumerator> {
        private final byte[] myBuffer = new byte[12];

        private RecordBufferHandler() {
        }

        @Override
        protected int recordWriteOffset(PersistentEnumerator enumerator, byte[] buf) {
            return (int)enumerator.myStorage.length();
        }

        @Override
        @NotNull
        byte[] getRecordBuffer(PersistentEnumerator t) {
            if (this.myBuffer == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentEnumerator$RecordBufferHandler.getRecordBuffer must not return null");
            }
            return this.myBuffer;
        }

        @Override
        void setupRecord(PersistentEnumerator enumerator, int hashCode, int dataOffset, byte[] buf) {
            Bits.putInt(buf, 0, 0);
            Bits.putInt(buf, 4, hashCode);
            Bits.putInt(buf, 8, dataOffset);
        }
    }
}

