/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.Processor;
import com.intellij.util.io.Bits;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.IntToIntBtree;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.ResizeableMappedFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentBTreeEnumerator<Data>
extends PersistentEnumeratorBase<Data> {
    private static final int PAGE_SIZE;
    private static final int DEFAULT_PAGE_SIZE = 4096;
    private static final int RECORD_SIZE = 4;
    private static final int VALUE_PAGE_SIZE = 0x100000;
    private int myLogicalFileLength;
    private int myDataPageStart;
    private int myFirstPageStart;
    private int myDataPageOffset;
    private int myDuplicatedValuesPageStart;
    private int myDuplicatedValuesPageOffset;
    private static final int COLLISION_OFFSET = 4;
    private int valuesCount;
    private int collisions;
    private IntToIntBtree btree;
    private final boolean myInlineKeysNoMapping;
    private boolean myExternalKeysNoMapping;
    private static final int DIRTY_MAGIC = -1161946761;
    private static final int VERSION = 8;
    private static final int CORRECTLY_CLOSED_MAGIC;
    private static PersistentEnumeratorBase.Version ourVersion;
    private static final int KEY_SHIFT = 1;
    private final int[] myResultBuf = new int[1];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentBTreeEnumerator(File file, KeyDescriptor<Data> dataDescriptor, int initialSize) throws IOException {
        super(file, new ResizeableMappedFile(file, initialSize, ourLock, 0x100000, true), dataDescriptor, initialSize, ourVersion, new RecordBufferHandler(), false);
        this.myInlineKeysNoMapping = this.myDataDescriptor instanceof InlineKeyDescriptor && !this.wantKeyMapping();
        boolean bl = this.myExternalKeysNoMapping = !(this.myDataDescriptor instanceof InlineKeyDescriptor) && !this.wantKeyMapping();
        if (this.btree == null) {
            PagedFileStorage.StorageLock storageLock = ourLock;
            synchronized (storageLock) {
                this.storeVars(false);
                this.initBtree(false);
                this.storeBTreeVars(false);
            }
        }
    }

    private File indexFile(File file) {
        return new File(file.getPath() + "_i");
    }

    protected boolean wantKeyMapping() {
        return false;
    }

    private void initBtree(boolean initial) throws IOException {
        this.btree = new IntToIntBtree(PAGE_SIZE, this.indexFile(this.myFile), initial);
    }

    private void storeVars(boolean toDisk) {
        this.myLogicalFileLength = this.store(20, this.myLogicalFileLength, toDisk);
        this.myDataPageStart = this.store(24, this.myDataPageStart, toDisk);
        this.myDataPageOffset = this.store(28, this.myDataPageOffset, toDisk);
        this.myFirstPageStart = this.store(32, this.myFirstPageStart, toDisk);
        this.myDuplicatedValuesPageStart = this.store(36, this.myDuplicatedValuesPageStart, toDisk);
        this.myDuplicatedValuesPageOffset = this.store(40, this.myDuplicatedValuesPageOffset, toDisk);
        this.valuesCount = this.store(44, this.valuesCount, toDisk);
        this.collisions = this.store(48, this.collisions, toDisk);
        this.storeBTreeVars(toDisk);
    }

    private void storeBTreeVars(boolean toDisk) {
        if (this.btree != null) {
            int BTREE_DATA_START = 52;
            this.btree.persistVars(new IntToIntBtree.BtreeDataStorage(){

                @Override
                public int persistInt(int offset, int value, boolean toDisk) {
                    return PersistentBTreeEnumerator.this.store(52 + offset, value, toDisk);
                }
            }, toDisk);
        }
    }

    private int store(int offset, int value, boolean toDisk) {
        assert (offset + 4 < PAGE_SIZE);
        if (toDisk) {
            this.myStorage.putInt(offset, value);
        } else {
            value = this.myStorage.getInt(offset);
        }
        return value;
    }

    @Override
    protected void setupEmptyFile() throws IOException {
        this.myLogicalFileLength = PAGE_SIZE;
        this.myDataPageStart = -1;
        this.myFirstPageStart = -1;
        this.myDuplicatedValuesPageStart = -1;
        this.initBtree(true);
        this.storeVars(true);
    }

    @Override
    protected void doClose() throws IOException {
        super.doClose();
        this.btree.doClose();
    }

    private int allocPage() {
        int pageStart = this.myLogicalFileLength;
        this.myLogicalFileLength += PAGE_SIZE;
        return pageStart;
    }

    @Override
    public boolean processAllDataObject(final Processor<Data> processor, final @Nullable PersistentEnumeratorBase.DataFilter filter) throws IOException {
        if (this.myInlineKeysNoMapping) {
            return this.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

                @Override
                public boolean process(int record) throws IOException {
                    if (filter == null || filter.accept(record)) {
                        Object data = ((InlineKeyDescriptor)PersistentBTreeEnumerator.this.myDataDescriptor).fromInt(this.getCurrentKey());
                        return processor.process(data);
                    }
                    return true;
                }
            });
        }
        return super.processAllDataObject(processor, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean traverseAllRecords(PersistentEnumeratorBase.RecordsProcessor p) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            ArrayList<IntToIntBtree.BtreeIndexNodeView> leafPages = new ArrayList<IntToIntBtree.BtreeIndexNodeView>();
            this.btree.doFlush();
            this.btree.root.syncWithStore();
            this.collectLeafPages(this.btree.root, leafPages);
            Collections.sort(leafPages, new Comparator<IntToIntBtree.BtreeIndexNodeView>(){

                @Override
                public int compare(IntToIntBtree.BtreeIndexNodeView o1, IntToIntBtree.BtreeIndexNodeView o2) {
                    return o1.address - o2.address;
                }
            });
            for (IntToIntBtree.BtreeIndexNodeView page : leafPages) {
                for (int key : page.exportKeys()) {
                    boolean hasMapping = this.btree.get(key, this.myResultBuf);
                    p.setCurrentKey(key);
                    assert (hasMapping);
                    int record = this.myResultBuf[0];
                    if (record > 0) {
                        if (p.process(record)) continue;
                        return false;
                    }
                    int rec = -record;
                    while (rec != 0) {
                        int id = this.myStorage.getInt(rec);
                        if (!p.process(id)) {
                            return false;
                        }
                        rec = this.myStorage.getInt(rec + 4);
                    }
                }
            }
            return true;
        }
    }

    private void collectLeafPages(IntToIntBtree.BtreeIndexNodeView node, List<IntToIntBtree.BtreeIndexNodeView> leafPages) {
        if (node.isIndexLeaf()) {
            leafPages.add(node);
            return;
        }
        for (int i = 0; i <= node.getChildrenCount(); ++i) {
            IntToIntBtree.BtreeIndexNodeView newNode = new IntToIntBtree.BtreeIndexNodeView(this.btree);
            newNode.setAddress(-node.addressAt(i));
            this.collectLeafPages(newNode, leafPages);
        }
    }

    @Override
    protected int indexToAddr(int idx) {
        if (this.myExternalKeysNoMapping) {
            IntToIntBtree.myAssert(idx > 0);
            return idx - 1;
        }
        int anInt = this.myStorage.getInt(idx);
        return anInt;
    }

    @Override
    protected int setupValueId(int hashCode, int dataOff) {
        if (this.myExternalKeysNoMapping) {
            return dataOff + 1;
        }
        PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase> recordHandler = this.getRecordHandler();
        byte[] buf = recordHandler.getRecordBuffer(this);
        int pos = recordHandler.recordWriteOffset(this, buf);
        this.myStorage.ensureSize(pos + buf.length);
        if (!this.myInlineKeysNoMapping) {
            this.myStorage.putInt(pos, dataOff);
        }
        return pos;
    }

    @Override
    public void setRecordHandler(PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase> recordHandler) {
        this.myExternalKeysNoMapping = false;
        super.setRecordHandler(recordHandler);
    }

    @Override
    public Data getValue(int keyId, int processingKey) throws IOException {
        if (this.myInlineKeysNoMapping) {
            return (Data)((InlineKeyDescriptor)this.myDataDescriptor).fromInt(processingKey);
        }
        return super.getValue(keyId, processingKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized int enumerateImpl(Data value, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            int valueHC = this.myDataDescriptor.getHashCode(value);
            boolean hasMapping = this.btree.get(valueHC, this.myResultBuf);
            if (!hasMapping && onlyCheckForExisting) {
                return 0;
            }
            int indexNodeValueAddress = hasMapping ? this.myResultBuf[0] : 0;
            int collisionAddress = 0;
            Object existingData = null;
            if (!this.myInlineKeysNoMapping) {
                collisionAddress = 0;
                if (indexNodeValueAddress > 0) {
                    Data candidate = this.valueOf(indexNodeValueAddress);
                    if (this.myDataDescriptor.isEqual(value, candidate)) {
                        if (!saveNewValue) {
                            return indexNodeValueAddress;
                        }
                        existingData = candidate;
                    }
                    collisionAddress = indexNodeValueAddress;
                } else if (indexNodeValueAddress < 0) {
                    collisionAddress = -indexNodeValueAddress;
                    while (true) {
                        int address;
                        Data candidate;
                        if (this.myDataDescriptor.isEqual(value, candidate = this.valueOf(address = this.myStorage.getInt(collisionAddress)))) {
                            if (!saveNewValue) {
                                return address;
                            }
                            existingData = candidate;
                            break;
                        }
                        int newCollisionAddress = this.myStorage.getInt(collisionAddress + 4);
                        if (newCollisionAddress == 0) break;
                        collisionAddress = newCollisionAddress;
                    }
                }
                if (onlyCheckForExisting) {
                    return 0;
                }
            } else if (hasMapping) {
                if (!saveNewValue) {
                    return indexNodeValueAddress;
                }
                existingData = value;
            }
            int newValueId = this.writeData(value, valueHC);
            ++this.valuesCount;
            if (this.valuesCount % 50000 == 0 && IOStatistics.DEBUG) {
                IOStatistics.dump("Index " + this.myFile + ", values " + this.valuesCount + ", storage size:" + this.myStorage.length());
                this.btree.dumpStatistics();
            }
            if (collisionAddress != 0) {
                if (existingData != null) {
                    if (indexNodeValueAddress > 0) {
                        this.btree.put(valueHC, newValueId);
                    } else {
                        this.myStorage.putInt(collisionAddress, newValueId);
                    }
                } else {
                    if (indexNodeValueAddress > 0) {
                        int duplicatedValueOff = this.nextDuplicatedValueRecord();
                        this.btree.put(valueHC, -duplicatedValueOff);
                        this.myStorage.putInt(duplicatedValueOff, indexNodeValueAddress);
                        collisionAddress = duplicatedValueOff;
                        ++this.collisions;
                    }
                    ++this.collisions;
                    int duplicatedValueOff = this.nextDuplicatedValueRecord();
                    this.myStorage.putInt(collisionAddress + 4, duplicatedValueOff);
                    this.myStorage.putInt(duplicatedValueOff, newValueId);
                    this.myStorage.putInt(duplicatedValueOff + 4, 0);
                }
            } else {
                this.btree.put(valueHC, newValueId);
            }
            return newValueId;
        }
    }

    @Override
    boolean canReEnumerate() {
        return true;
    }

    @Override
    public Data valueOf(int idx) throws IOException {
        if (this.myInlineKeysNoMapping) assert (false) : "No valueOf for inline keys with no mapping option";
        return super.valueOf(idx);
    }

    private int nextDuplicatedValueRecord() {
        if (this.myDuplicatedValuesPageStart == -1 || this.myDuplicatedValuesPageOffset == this.btree.pageSize) {
            this.myDuplicatedValuesPageStart = this.allocPage();
            this.myDuplicatedValuesPageOffset = 0;
        }
        int duplicatedValueOff = this.myDuplicatedValuesPageOffset;
        this.myDuplicatedValuesPageOffset += 8;
        return this.myDuplicatedValuesPageStart + duplicatedValueOff;
    }

    @Override
    protected void doFlush() throws IOException {
        this.btree.doFlush();
        this.storeVars(true);
        super.doFlush();
    }

    static {
        int pageSize;
        try {
            String property = System.getProperty("idea.btree.page.size");
            pageSize = property != null ? Integer.parseInt(property, 10) : 4096;
        }
        catch (NumberFormatException ex) {
            pageSize = 4096;
        }
        PAGE_SIZE = pageSize;
        assert (0x100000 % PAGE_SIZE == 0) : "Page size should be divisor of 1048576";
        CORRECTLY_CLOSED_MAGIC = 247118596 + PAGE_SIZE;
        ourVersion = new PersistentEnumeratorBase.Version(CORRECTLY_CLOSED_MAGIC, -1161946761);
    }

    private static class RecordBufferHandler
    extends PersistentEnumeratorBase.RecordBufferHandler<PersistentBTreeEnumerator> {
        private byte[] myBuffer;

        private RecordBufferHandler() {
        }

        @Override
        int recordWriteOffset(PersistentBTreeEnumerator enumerator, byte[] buf) {
            if (enumerator.myFirstPageStart == -1) {
                enumerator.myFirstPageStart = (enumerator.myDataPageStart = enumerator.allocPage());
            }
            if (enumerator.myDataPageOffset + buf.length + 4 > ((PersistentBTreeEnumerator)enumerator).btree.pageSize) {
                assert (enumerator.myDataPageOffset + 4 <= ((PersistentBTreeEnumerator)enumerator).btree.pageSize);
                int prevDataPageStart = enumerator.myDataPageStart + ((PersistentBTreeEnumerator)enumerator).btree.pageSize - 4;
                enumerator.myDataPageStart = enumerator.allocPage();
                enumerator.myStorage.putInt(prevDataPageStart, enumerator.myDataPageStart);
                enumerator.myDataPageOffset = 0;
            }
            int recordWriteOffset = enumerator.myDataPageOffset;
            assert (recordWriteOffset + buf.length + 4 <= ((PersistentBTreeEnumerator)enumerator).btree.pageSize);
            enumerator.myDataPageOffset += buf.length;
            return recordWriteOffset + enumerator.myDataPageStart;
        }

        @Override
        @NotNull
        byte[] getRecordBuffer(PersistentBTreeEnumerator enumerator) {
            if (this.myBuffer == null) {
                this.myBuffer = new byte[enumerator.myInlineKeysNoMapping ? 0 : 4];
            }
            if (this.myBuffer == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentBTreeEnumerator$RecordBufferHandler.getRecordBuffer must not return null");
            }
            return this.myBuffer;
        }

        @Override
        void setupRecord(PersistentBTreeEnumerator enumerator, int hashCode, int dataOffset, byte[] buf) {
            if (!enumerator.myInlineKeysNoMapping) {
                Bits.putInt(buf, 0, dataOffset);
            }
        }
    }
}

