/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class SortedList<T>
extends AbstractList<T> {
    private final SortedMap<T, List<T>> myMap;
    private final Comparator<T> myComparator;
    private List<T> myDelegate = null;

    public SortedList(Comparator<T> comparator) {
        this.myComparator = comparator;
        this.myMap = new TreeMap<T, List<T>>(comparator);
    }

    public Comparator<T> getComparator() {
        return this.myComparator;
    }

    @Override
    public void add(int index, T element) {
        this._addToMap(element);
    }

    private void _addToMap(T element) {
        ArrayList<T> group = (ArrayList<T>)this.myMap.get(element);
        if (group == null) {
            group = new ArrayList<T>();
            this.myMap.put(element, group);
        }
        group.add(element);
        this.myDelegate = null;
    }

    @Override
    public boolean add(T t) {
        this._addToMap(t);
        return true;
    }

    @Override
    public T remove(int index) {
        T value = this.get(index);
        this.remove(value);
        return value;
    }

    @Override
    public boolean remove(Object value) {
        List group = (List)this.myMap.remove(value);
        if (group == null) {
            return false;
        }
        group.remove(value);
        if (!group.isEmpty()) {
            this.myMap.put(group.get(0), group);
        }
        this.myDelegate = null;
        return true;
    }

    @Override
    public T get(int index) {
        this.ensureLinearized();
        return this.myDelegate.get(index);
    }

    private List<T> ensureLinearized() {
        if (this.myDelegate == null) {
            this.myDelegate = ContainerUtil.concat(this.myMap.values());
        }
        return this.myDelegate;
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.myDelegate = null;
    }

    @Override
    public int size() {
        this.ensureLinearized();
        return this.myDelegate.size();
    }
}

