/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.IntHashEntry;
import com.intellij.util.containers.StripedReentrantLocks;

class IntSegment<V> {
    private static final StripedReentrantLocks STRIPED_REENTRANT_LOCKS = StripedReentrantLocks.getInstance();
    private final byte lockIndex = (byte)STRIPED_REENTRANT_LOCKS.allocateLockIndex();
    volatile int count;
    int modCount;
    volatile IntHashEntry[] table;
    final float loadFactor;

    public void lock() {
        STRIPED_REENTRANT_LOCKS.lock(this.lockIndex & 0xFF);
    }

    public void unlock() {
        STRIPED_REENTRANT_LOCKS.unlock(this.lockIndex & 0xFF);
    }

    int threshold() {
        return (int)((float)this.table.length * this.loadFactor);
    }

    IntSegment(int initialCapacity, float lf) {
        this.loadFactor = lf;
        this.setTable(new IntHashEntry[initialCapacity]);
    }

    void setTable(IntHashEntry[] newTable) {
        this.table = newTable;
    }

    IntHashEntry<V> getFirst(int hash) {
        IntHashEntry[] tab = this.table;
        return tab[hash & tab.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V readValueUnderLock(IntHashEntry<V> e) {
        this.lock();
        try {
            Object v = e.value;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    public V get(int key) {
        if (this.count != 0) {
            IntHashEntry<V> e = this.getFirst(key);
            while (e != null) {
                if (key == e.key) {
                    Object v = e.value;
                    if (v != null) {
                        return v;
                    }
                    return this.readValueUnderLock(e);
                }
                e = e.next;
            }
        }
        return null;
    }

    public boolean containsKey(int key) {
        if (this.count != 0) {
            IntHashEntry<V> e = this.getFirst(key);
            while (e != null) {
                if (key == e.key) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsValue(Object value) {
        if (this.count != 0) {
            for (IntHashEntry intHashEntry : this.table) {
                void var5_5;
                while (var5_5 != null) {
                    Object v = var5_5.value;
                    if (v == null) {
                        v = this.readValueUnderLock((IntHashEntry<V>)var5_5);
                    }
                    if (value.equals(v)) {
                        return true;
                    }
                    IntHashEntry intHashEntry2 = var5_5.next;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(int key, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        this.lock();
        try {
            IntHashEntry<V> e = this.getFirst(key);
            while (e != null && key != e.key) {
                e = e.next;
            }
            boolean replaced = false;
            if (e != null && oldValue.equals(e.value)) {
                replaced = true;
                e.value = newValue;
            }
            boolean bl = replaced;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V replace(int key, V newValue) {
        if (newValue == null) {
            throw new NullPointerException();
        }
        this.lock();
        try {
            IntHashEntry<V> e = this.getFirst(key);
            while (e != null && key != e.key) {
                e = e.next;
            }
            V oldValue = null;
            if (e != null) {
                oldValue = e.value;
                e.value = newValue;
            }
            V v = oldValue;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V put(int key, V value, boolean onlyIfAbsent) {
        this.lock();
        try {
            V oldValue;
            IntHashEntry first;
            int c = this.count;
            if (c++ > this.threshold()) {
                this.rehash();
            }
            IntHashEntry[] tab = this.table;
            int index = key & tab.length - 1;
            IntHashEntry e = first = tab[index];
            while (e != null && key != e.key) {
                e = e.next;
            }
            if (e != null) {
                oldValue = e.value;
                if (!onlyIfAbsent) {
                    e.value = value;
                }
            } else {
                oldValue = null;
                ++this.modCount;
                tab[index] = new IntHashEntry(key, first, value);
                this.count = c;
            }
            V v = oldValue;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    void rehash() {
        IntHashEntry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            return;
        }
        IntHashEntry[] newTable = new IntHashEntry[oldCapacity << 1];
        int sizeMask = newTable.length - 1;
        for (int i = 0; i < oldCapacity; ++i) {
            int k;
            IntHashEntry e = oldTable[i];
            if (e == null) continue;
            IntHashEntry next = e.next;
            int idx = e.key & sizeMask;
            if (next == null) {
                newTable[idx] = e;
                continue;
            }
            IntHashEntry lastRun = e;
            int lastIdx = idx;
            IntHashEntry last = next;
            while (last != null) {
                k = last.key & sizeMask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last;
                }
                last = last.next;
            }
            newTable[lastIdx] = lastRun;
            IntHashEntry p = e;
            while (p != lastRun) {
                k = p.key & sizeMask;
                IntHashEntry n = newTable[k];
                newTable[k] = new IntHashEntry(p.key, n, p.value);
                p = p.next;
            }
        }
        this.setTable(newTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(int key, Object value) {
        this.lock();
        try {
            IntHashEntry first;
            int c = this.count - 1;
            IntHashEntry[] tab = this.table;
            int index = key & tab.length - 1;
            IntHashEntry e = first = tab[index];
            while (e != null && key != e.key) {
                e = e.next;
            }
            V oldValue = null;
            if (e != null) {
                Object v = e.value;
                if (value == null || value.equals(v)) {
                    oldValue = v;
                    ++this.modCount;
                    IntHashEntry newFirst = e.next;
                    IntHashEntry p = first;
                    while (p != e) {
                        newFirst = new IntHashEntry(p.key, newFirst, p.value);
                        p = p.next;
                    }
                    tab[index] = newFirst;
                    this.count = c;
                }
            }
            V v = oldValue;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.count != 0) {
            this.lock();
            try {
                IntHashEntry[] tab = this.table;
                for (int i = 0; i < tab.length; ++i) {
                    tab[i] = null;
                }
                ++this.modCount;
                this.count = 0;
            }
            finally {
                this.unlock();
            }
        }
    }
}

