/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class FList<E>
extends AbstractList<E> {
    private static final FList<?> EMPTY_LIST = new FList();
    private E myHead;
    private FList<E> myTail;
    private int mySize;
    private List<E> myReversedList;

    private FList() {
    }

    private FList(E head, FList<E> tail) {
        this.myHead = head;
        this.myTail = tail;
        this.mySize = tail.size() + 1;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("index = " + index + ", size = " + this.mySize);
        }
        FList<E> current = this;
        while (index > 0) {
            current = current.myTail;
            --index;
        }
        return current.myHead;
    }

    public E getHead() {
        return this.myHead;
    }

    public FList<E> prepend(E elem) {
        return new FList<E>(elem, this);
    }

    public FList<E> without(E elem) {
        FList<E> front = FList.emptyList();
        FList<E> current = this;
        while (!current.isEmpty()) {
            if (elem == null ? current.myHead == null : current.myHead.equals(elem)) {
                FList<E> result = current.myTail;
                while (!front.isEmpty()) {
                    result = result.prepend(front.myHead);
                    front = front.myTail;
                }
                return result;
            }
            front = front.prepend(current.myHead);
            current = current.myTail;
        }
        return this;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private FList<E> list;
            {
                this.list = FList.this;
            }

            @Override
            public boolean hasNext() {
                return this.list.size() > 0;
            }

            @Override
            public E next() {
                if (this.list.size() == 0) {
                    throw new NoSuchElementException();
                }
                Object res = this.list.myHead;
                this.list = this.list.getTail();
                assert (this.list != null);
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public FList<E> getTail() {
        return this.myTail;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    public List<E> getReversedList() {
        List<E> res = this.myReversedList;
        if (res == null) {
            res = new ArrayList(this);
            Collections.reverse(res);
            this.myReversedList = res;
        }
        return res;
    }

    public static <E> FList<E> emptyList() {
        return EMPTY_LIST;
    }
}

