/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Iterator;
import java.util.List;

public class CompositeIterator<Key>
implements Iterator<Key> {
    private int myPreviousIdx;
    private int myIdx;
    private final List<Iterator<Key>> myIterators;

    public CompositeIterator(List<Iterator<Key>> iterators) {
        this.myIterators = iterators;
        this.myIdx = -1;
        this.myPreviousIdx = -1;
        for (int i = 0; i < this.myIterators.size(); ++i) {
            Iterator<Key> iterator = this.myIterators.get(i);
            if (!iterator.hasNext()) continue;
            this.myIdx = i;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.myIdx >= 0 && this.myIterators.get(this.myIdx).hasNext();
    }

    @Override
    public Key next() {
        Key result = this.myIterators.get(this.myIdx).next();
        this.recalculateCurrent();
        return result;
    }

    private void recalculateCurrent() {
        if (this.myIdx == -1) {
            return;
        }
        if (!this.myIterators.get(this.myIdx).hasNext()) {
            this.myPreviousIdx = this.myIdx;
            this.myIdx = -1;
            for (int i = this.myPreviousIdx; i < this.myIterators.size(); ++i) {
                Iterator<Key> iterator = this.myIterators.get(i);
                if (!iterator.hasNext()) continue;
                this.myIdx = i;
                break;
            }
        }
    }

    @Override
    public void remove() {
        if (this.myPreviousIdx != -1 && this.myPreviousIdx != this.myIdx) {
            Iterator<Key> keyIterator = this.myIterators.get(this.myPreviousIdx);
            keyIterator.remove();
        } else {
            this.myIterators.get(this.myIdx).remove();
        }
        this.recalculateCurrent();
    }
}

