/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionCache;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");

    private ReflectionUtil() {
    }

    @Nullable
    public static Type resolveVariable(TypeVariable variable, Class classType) {
        return ReflectionUtil.resolveVariable(variable, classType, true);
    }

    @Nullable
    public static Type resolveVariable(TypeVariable variable, Class classType, boolean resolveInInterfacesOnly) {
        Class<?> aClass = ReflectionUtil.getRawType(classType);
        int index = ArrayUtil.find(ReflectionCache.getTypeParameters(aClass), variable);
        if (index >= 0) {
            return variable;
        }
        Class[] classes = ReflectionCache.getInterfaces(aClass);
        Type[] genericInterfaces = ReflectionCache.getGenericInterfaces(aClass);
        for (int i = 0; i <= classes.length; ++i) {
            Type type;
            Class anInterface;
            if (i < classes.length) {
                anInterface = classes[i];
            } else {
                anInterface = ReflectionCache.getSuperClass(aClass);
                if (resolveInInterfacesOnly || anInterface == null) continue;
            }
            Type resolved = ReflectionUtil.resolveVariable(variable, anInterface);
            if (resolved instanceof Class || resolved instanceof ParameterizedType) {
                return resolved;
            }
            if (!(resolved instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)resolved;
            index = ArrayUtil.find(ReflectionCache.getTypeParameters(anInterface), typeVariable);
            if (index < 0) {
                LOG.error("Cannot resolve type variable:\ntypeVariable = " + typeVariable + "\n" + "genericDeclaration = " + ReflectionUtil.declarationToString(typeVariable.getGenericDeclaration()) + "\n" + "searching in " + ReflectionUtil.declarationToString(anInterface));
            }
            Type type2 = type = i < genericInterfaces.length ? genericInterfaces[i] : aClass.getGenericSuperclass();
            if (type instanceof Class) {
                return Object.class;
            }
            if (type instanceof ParameterizedType) {
                return ReflectionUtil.getActualTypeArguments((ParameterizedType)type)[index];
            }
            throw new AssertionError((Object)("Invalid type: " + type));
        }
        return null;
    }

    public static String declarationToString(GenericDeclaration anInterface) {
        return anInterface.toString() + Arrays.asList(anInterface.getTypeParameters()) + " loaded by " + ((Class)anInterface).getClassLoader();
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtil.getRawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ReflectionUtil.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        assert (false) : type;
        return null;
    }

    public static Type[] getActualTypeArguments(ParameterizedType parameterizedType) {
        return ReflectionCache.getActualTypeArguments(parameterizedType);
    }

    @Nullable
    public static Class<?> substituteGenericType(Type genericType, Type classType) {
        if (genericType instanceof TypeVariable) {
            int index;
            Class<?> aClass = ReflectionUtil.getRawType(classType);
            Type type = ReflectionUtil.resolveVariable((TypeVariable)genericType, aClass);
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable && classType instanceof ParameterizedType && (index = ArrayUtil.find(ReflectionCache.getTypeParameters(aClass), type)) >= 0) {
                return ReflectionUtil.getRawType(ReflectionUtil.getActualTypeArguments((ParameterizedType)classType)[index]);
            }
        } else {
            return ReflectionUtil.getRawType(genericType);
        }
        return null;
    }

    public static ArrayList<Field> collectFields(Class clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        ReflectionUtil.collectFields(clazz, result);
        return result;
    }

    public static Field findField(Class clazz, @Nullable Class type, String name) throws NoSuchFieldException {
        ArrayList<Field> fields = ReflectionUtil.collectFields(clazz);
        for (Field each : fields) {
            if (!name.equals(each.getName()) || type != null && !each.getType().equals(type)) continue;
            return each;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    public static Field findAssignableField(Class clazz, Class type, String name) throws NoSuchFieldException {
        ArrayList<Field> fields = ReflectionUtil.collectFields(clazz);
        for (Field each : fields) {
            if (!name.equals(each.getName()) || !type.isAssignableFrom(each.getType())) continue;
            return each;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    private static void collectFields(Class clazz, ArrayList<Field> result) {
        Class<?>[] interfaces;
        Field[] fields = clazz.getDeclaredFields();
        result.addAll(Arrays.asList(fields));
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtil.collectFields(superClass, result);
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            ReflectionUtil.collectFields(each, result);
        }
    }

    public static void resetField(Class clazz, Class type, String name) {
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(Object object, Class type, String name) {
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), type, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(Object object, String name) {
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), null, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(@Nullable Object object, Field field) {
        field.setAccessible(true);
        Class<?> type = field.getType();
        try {
            if (type.isPrimitive()) {
                if (Boolean.TYPE.equals(type)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type)) {
                    field.set(object, new Integer(0));
                } else if (Double.TYPE.equals(type)) {
                    field.set(object, new Double(0.0));
                } else if (Float.TYPE.equals(type)) {
                    field.set(object, new Float(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            LOG.info(e);
        }
    }

    @Nullable
    public static Method findMethod(Method[] methods, @NonNls @NotNull String name, Class ... parameters) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ReflectionUtil.findMethod must not be null");
        }
        for (Method method : methods) {
            if (!name.equals(method.getName()) || !Arrays.equals(parameters, method.getParameterTypes())) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@NotNull Class aClass, @NonNls @NotNull String name, Class ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ReflectionUtil.getMethod must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ReflectionUtil.getMethod must not be null");
        }
        return ReflectionUtil.findMethod(ReflectionCache.getMethods(aClass), name, parameters);
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class aClass, @NonNls @NotNull String name, Class ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ReflectionUtil.getDeclaredMethod must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ReflectionUtil.getDeclaredMethod must not be null");
        }
        return ReflectionUtil.findMethod(aClass.getDeclaredMethods(), name, parameters);
    }

    public static Object getField(Class objectClass, Object object, Class type, @NonNls String name) {
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, type, name);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static Type resolveVariableInHierarchy(TypeVariable variable, Class aClass) {
        Type type;
        Class current = aClass;
        while ((type = ReflectionUtil.resolveVariable(variable, current, false)) == null) {
            if ((current = ReflectionCache.getSuperClass(current)) != null) continue;
            return null;
        }
        if (type instanceof TypeVariable) {
            return ReflectionUtil.resolveVariableInHierarchy((TypeVariable)type, aClass);
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <T> Constructor<T> getDefaultConstructor(Class<T> aClass) {
        Constructor<T> constructor;
        Constructor<T> constructor2;
        try {
            Constructor<T> constructor3 = aClass.getConstructor(new Class[0]);
            constructor3.setAccessible(true);
            constructor2 = constructor3;
        }
        catch (NoSuchMethodException e) {
            LOG.error("No default constructor in " + aClass, e);
            constructor = null;
            throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionUtil.getDefaultConstructor must not return null");
        }
        constructor = constructor2;
        if (constructor2 != null) return constructor;
        throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionUtil.getDefaultConstructor must not return null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <T> T createInstance(Constructor<T> constructor, Object ... args) {
        T t;
        T t2;
        try {
            t2 = constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            LOG.error(e);
            t = null;
            throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionUtil.createInstance must not return null");
        }
        catch (IllegalAccessException e) {
            LOG.error(e);
            t = null;
            throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionUtil.createInstance must not return null");
        }
        catch (InvocationTargetException e) {
            LOG.error(e);
            t = null;
            throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionUtil.createInstance must not return null");
        }
        t = t2;
        if (t2 != null) return t;
        throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionUtil.createInstance must not return null");
    }

    public static void resetThreadLocals() {
        try {
            Field field = Thread.class.getDeclaredField("threadLocals");
            field.setAccessible(true);
            field.set(Thread.currentThread(), null);
        }
        catch (Throwable e) {
            LOG.info(e);
        }
    }
}

