/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.URLUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.Reflection;

@Deprecated
public class ImageLoader
implements Serializable {
    private static final Component ourComponent = new Component(){};
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ImageLoader");

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            LOG.info(ex);
        }
        return !mediatracker.isErrorID(1);
    }

    @Nullable
    public static Image loadFromResource(@NonNls String s) {
        int stackFrameCount = 2;
        Class callerClass = Reflection.getCallerClass((int)stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = Reflection.getCallerClass((int)(++stackFrameCount));
        }
        if (callerClass == null) {
            callerClass = Reflection.getCallerClass((int)1);
        }
        return ImageLoader.loadFromResource(s, callerClass);
    }

    @Nullable
    public static Image loadFromResource(String s, Class aClass) {
        InputStream stream = aClass.getResourceAsStream(s);
        return stream != null ? ImageLoader.loadFromStream(stream) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadFromStream(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ImageLoader.loadFromStream must not be null");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream.getInternalBuffer(), 0, outputStream.size());
            ImageLoader.waitForImage(image);
            return image;
        }
        catch (Exception ex) {
            LOG.error(ex);
            return null;
        }
    }

    public static Image loadFromUrl(URL url) {
        try {
            return ImageLoader.loadFromStream(URLUtil.openStream(url));
        }
        catch (IOException e) {
            LOG.error(e);
            return null;
        }
    }

    public static boolean isGoodSize(Icon icon) {
        return IconLoader.isGoodSize(icon);
    }
}

