/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static Throwable getRootCause(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public static <T extends Throwable> T findCause(Throwable e, Class<T> klass) {
        while (e != null && !klass.isInstance(e)) {
            e = e.getCause();
        }
        return (T)e;
    }

    public static boolean causedBy(Throwable e, Class klass) {
        return ExceptionUtil.findCause(e, klass) != null;
    }

    @NotNull
    public static Throwable makeStackTraceRelative(@NotNull Throwable th, @NotNull Throwable relativeTo) {
        if (th == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ExceptionUtil.makeStackTraceRelative must not be null");
        }
        if (relativeTo == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ExceptionUtil.makeStackTraceRelative must not be null");
        }
        StackTraceElement[] trace = th.getStackTrace();
        StackTraceElement[] rootTrace = relativeTo.getStackTrace();
        int len = Math.min(trace.length, rootTrace.length);
        for (int i = 0; i < len; ++i) {
            if (trace[trace.length - i - 1].equals(rootTrace[rootTrace.length - i - 1])) continue;
            int newDepth = trace.length - i;
            th.setStackTrace(Arrays.asList(trace).subList(0, newDepth).toArray(new StackTraceElement[newDepth]));
            break;
        }
        Throwable throwable = th;
        if (throwable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ExceptionUtil.makeStackTraceRelative must not return null");
        }
        return throwable;
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ExceptionUtil.getThrowableText must not be null");
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        aThrowable.printStackTrace(writer);
        String string = stringWriter.getBuffer().toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ExceptionUtil.getThrowableText must not return null");
        }
        return string;
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable, @NonNls @NotNull String stackFrameSkipPattern) {
        if (aThrowable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ExceptionUtil.getThrowableText must not be null");
        }
        if (stackFrameSkipPattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ExceptionUtil.getThrowableText must not be null");
        }
        String prefix = "\tat ";
        final String skipPattern = "\tat " + stackFrameSkipPattern;
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter){
            boolean skipping;
            {
                super(x0);
                this.skipping = false;
            }

            @Override
            public void println(String x) {
                boolean curSkipping = this.skipping;
                if (x != null) {
                    if (!this.skipping && x.startsWith(skipPattern)) {
                        curSkipping = true;
                    } else if (this.skipping && !x.startsWith("\tat ")) {
                        curSkipping = false;
                    }
                    if (curSkipping && !this.skipping) {
                        super.println("\tin " + ExceptionUtil.stripPackage(x, skipPattern.length()));
                    }
                    this.skipping = curSkipping;
                    if (this.skipping) {
                        return;
                    }
                    super.println(x);
                }
            }
        };
        aThrowable.printStackTrace(writer);
        String string = stringWriter.getBuffer().toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ExceptionUtil.getThrowableText must not return null");
        }
        return string;
    }

    private static String stripPackage(String x, int offset) {
        int idx = offset;
        while (idx > 0 && idx < x.length() && !Character.isUpperCase(x.charAt(idx))) {
            idx = x.indexOf(46, idx) + 1;
        }
        return x.substring(Math.max(idx, offset));
    }

    @NotNull
    public static String getUserStackTrace(@NotNull Throwable aThrowable, Logger logger) {
        if (aThrowable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ExceptionUtil.getUserStackTrace must not be null");
        }
        String result = ExceptionUtil.getThrowableText(aThrowable, "com.intellij.");
        if (!result.contains("\n\tat")) {
            logger.error(aThrowable);
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ExceptionUtil.getUserStackTrace must not return null");
        }
        return string;
    }

    @Nullable
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ExceptionUtil.getMessage must not be null");
        }
        String result = e.getMessage();
        String exceptionPattern = "Exception: ";
        String errorPattern = "Error: ";
        while ((result == null || result.contains("Exception: ") || result.contains("Error: ")) && e.getCause() != null) {
            e = e.getCause();
            result = e.getMessage();
        }
        if (result != null) {
            result = ExceptionUtil.extractMessage(result, "Exception: ");
            result = ExceptionUtil.extractMessage(result, "Error: ");
        }
        return result;
    }

    @NotNull
    private static String extractMessage(@NotNull String result, @NotNull String errorPattern) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ExceptionUtil.extractMessage must not be null");
        }
        if (errorPattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ExceptionUtil.extractMessage must not be null");
        }
        if (result.lastIndexOf(errorPattern) >= 0) {
            result = result.substring(result.lastIndexOf(errorPattern) + errorPattern.length());
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ExceptionUtil.extractMessage must not return null");
        }
        return string;
    }
}

