/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.awt;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativePoint {
    private Component myComponent;
    private Point myPointOnComponent;
    private Component myOriginalComponent;
    private Point myOriginalPoint;

    public RelativePoint(@NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/awt/RelativePoint.<init> must not be null");
        }
        this.init(event.getComponent(), event.getPoint());
        this.myOriginalComponent = event.getComponent();
        this.myOriginalPoint = event.getPoint();
    }

    public RelativePoint(@NotNull Component aComponent, Point aPointOnComponent) {
        if (aComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/awt/RelativePoint.<init> must not be null");
        }
        this.init(aComponent, aPointOnComponent);
    }

    public RelativePoint(@NotNull Point screenPoint) {
        if (screenPoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/awt/RelativePoint.<init> must not be null");
        }
        Point p = new Point(screenPoint.x, screenPoint.y);
        Window[] windows = Window.getWindows();
        Window targetWindow = null;
        for (Window each : windows) {
            if (!each.isActive()) continue;
            targetWindow = each;
            break;
        }
        if (targetWindow == null) {
            targetWindow = JOptionPane.getRootFrame();
        }
        SwingUtilities.convertPointFromScreen(p, targetWindow);
        this.init(targetWindow, p);
    }

    private void init(@NotNull Component aComponent, Point aPointOnComponent) {
        if (aComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/awt/RelativePoint.init must not be null");
        }
        if (aComponent.isShowing()) {
            this.myComponent = SwingUtilities.getRootPane(aComponent);
            this.myPointOnComponent = SwingUtilities.convertPoint(aComponent, aPointOnComponent, this.myComponent);
        } else {
            this.myComponent = aComponent;
            this.myPointOnComponent = aPointOnComponent;
        }
        this.myOriginalComponent = this.myComponent;
        this.myOriginalPoint = this.myPointOnComponent;
    }

    public Component getComponent() {
        return this.myComponent;
    }

    public Point getPoint() {
        return this.myPointOnComponent;
    }

    public Point getPoint(@Nullable Component aTargetComponent) {
        if (aTargetComponent == null || aTargetComponent.getParent() == null || SwingUtilities.getWindowAncestor(aTargetComponent) == null) {
            return new Point();
        }
        return SwingUtilities.convertPoint(this.getComponent(), this.getPoint(), aTargetComponent);
    }

    @NotNull
    public RelativePoint getPointOn(@NotNull Component aTargetComponent) {
        if (aTargetComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/awt/RelativePoint.getPointOn must not be null");
        }
        Point point = this.getPoint(aTargetComponent);
        RelativePoint relativePoint = new RelativePoint(aTargetComponent, point);
        if (relativePoint == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/awt/RelativePoint.getPointOn must not return null");
        }
        return relativePoint;
    }

    @NotNull
    public Point getScreenPoint() {
        Point point = (Point)this.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, this.getComponent());
        Point point2 = point;
        if (point2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/awt/RelativePoint.getScreenPoint must not return null");
        }
        return point2;
    }

    @NotNull
    public MouseEvent toMouseEvent() {
        MouseEvent mouseEvent = new MouseEvent(this.myComponent, 0, 0L, 0, this.myPointOnComponent.x, this.myPointOnComponent.y, 1, false);
        if (mouseEvent == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/awt/RelativePoint.toMouseEvent must not return null");
        }
        return mouseEvent;
    }

    @NotNull
    public String toString() {
        String string = this.getPoint() + " on " + this.getComponent().toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/awt/RelativePoint.toString must not return null");
        }
        return string;
    }

    @NotNull
    public static RelativePoint getCenterOf(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/awt/RelativePoint.getCenterOf must not be null");
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/awt/RelativePoint.getCenterOf must not return null");
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getSouthEastOf(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/awt/RelativePoint.getSouthEastOf must not be null");
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/awt/RelativePoint.getSouthEastOf must not return null");
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getSouthWestOf(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/awt/RelativePoint.getSouthWestOf must not be null");
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x, visibleRect.y + visibleRect.height);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/awt/RelativePoint.getSouthWestOf must not return null");
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getNorthWestOf(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/awt/RelativePoint.getNorthWestOf must not be null");
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x, visibleRect.y);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/awt/RelativePoint.getNorthWestOf must not return null");
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getNorthEastOf(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/awt/RelativePoint.getNorthEastOf must not be null");
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width, visibleRect.y);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/awt/RelativePoint.getNorthEastOf must not return null");
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint fromScreen(Point screenPoint) {
        Frame root = JOptionPane.getRootFrame();
        SwingUtilities.convertPointFromScreen(screenPoint, root);
        RelativePoint relativePoint = new RelativePoint(root, screenPoint);
        if (relativePoint == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/awt/RelativePoint.fromScreen must not return null");
        }
        return relativePoint;
    }

    public Component getOriginalComponent() {
        return this.myOriginalComponent;
    }

    public Point getOriginalPoint() {
        return this.myOriginalPoint;
    }
}

