/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nullable;

public abstract class SwingActionWrapper<T extends JComponent>
implements Action {
    private Action myDelegate;
    private T myComponent;
    private Object myActionKey;

    public SwingActionWrapper(T component, KeyStroke keyStroke) {
        this.myComponent = component;
        Object actionKey = SwingActionWrapper.getKeyForActionMap(component, keyStroke);
        if (actionKey == null) {
            String message = "no input mapping for keyStroke: " + keyStroke;
            throw new IllegalArgumentException(message);
        }
        this.setActionForKey(actionKey);
    }

    public Action getDelegate() {
        return this.myDelegate;
    }

    public T getComponent() {
        return this.myComponent;
    }

    public Object getActionKey() {
        return this.myActionKey;
    }

    public SwingActionWrapper(T component, Object actionKey) {
        this.myComponent = component;
        this.setActionForKey(actionKey);
    }

    @Nullable
    public static Object getKeyForActionMap(JComponent component, KeyStroke keyStroke) {
        for (int i = 0; i < 3; ++i) {
            Object key;
            InputMap inputMap = component.getInputMap(i);
            if (inputMap == null || (key = inputMap.get(keyStroke)) == null) continue;
            return key;
        }
        return null;
    }

    private void setActionForKey(Object actionKey) {
        this.myActionKey = actionKey;
        this.myDelegate = ((JComponent)this.myComponent).getActionMap().get(actionKey);
        assert (this.myDelegate != null) : "action not found: " + actionKey;
        ((JComponent)this.myComponent).getActionMap().put(this.myActionKey, this);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myDelegate.addPropertyChangeListener(listener);
    }

    @Override
    public Object getValue(String key) {
        return this.myDelegate.getValue(key);
    }

    @Override
    public boolean isEnabled() {
        return this.myDelegate.isEnabled();
    }

    @Override
    public void putValue(String key, Object newValue) {
        this.myDelegate.putValue(key, newValue);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myDelegate.removePropertyChangeListener(listener);
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.myDelegate.setEnabled(newValue);
    }
}

