/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.Icon;

public class LayeredIcon
implements Icon {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ui.LayeredIcon");
    private final Icon[] myIcons;
    private final boolean[] myDisabledLayers;
    private final int[] myHShifts;
    private final int[] myVShifts;
    private int myWidth;
    private int myHeight;
    private int myXShift;
    private int myYShift;

    public LayeredIcon(int layerCount) {
        this.myIcons = new Icon[layerCount];
        this.myDisabledLayers = new boolean[layerCount];
        this.myHShifts = new int[layerCount];
        this.myVShifts = new int[layerCount];
    }

    public LayeredIcon(Icon ... icons) {
        this(icons.length);
        for (int i = 0; i < icons.length; ++i) {
            this.setIcon(icons[i], i);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LayeredIcon)) {
            return false;
        }
        LayeredIcon icon = (LayeredIcon)o;
        if (this.myHeight != icon.myHeight) {
            return false;
        }
        if (this.myWidth != icon.myWidth) {
            return false;
        }
        if (this.myXShift != icon.myXShift) {
            return false;
        }
        if (this.myYShift != icon.myYShift) {
            return false;
        }
        if (!Arrays.equals(this.myHShifts, icon.myHShifts)) {
            return false;
        }
        if (!Arrays.equals(this.myIcons, icon.myIcons)) {
            return false;
        }
        return Arrays.equals(this.myVShifts, icon.myVShifts);
    }

    public int hashCode() {
        return 0;
    }

    public void setIcon(Icon icon, int layer) {
        this.setIcon(icon, layer, 0, 0);
    }

    public Icon getIcon(int layer) {
        return this.myIcons[layer];
    }

    public Icon[] getAllLayers() {
        return this.myIcons;
    }

    public void setIcon(Icon icon, int layer, int hShift, int vShift) {
        if (icon instanceof LayeredIcon) {
            ((LayeredIcon)icon).checkIHaventIconInsideMe(this);
        }
        this.myIcons[layer] = icon;
        this.myHShifts[layer] = hShift;
        this.myVShifts[layer] = vShift;
        this.recalculateSize();
    }

    private void checkIHaventIconInsideMe(Icon icon) {
        LOG.assertTrue(icon != this);
        for (Icon child : this.myIcons) {
            if (!(child instanceof LayeredIcon)) continue;
            ((LayeredIcon)child).checkIHaventIconInsideMe(icon);
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        for (int i = 0; i < this.myIcons.length; ++i) {
            Icon icon = this.myIcons[i];
            if (icon == null || this.myDisabledLayers[i]) continue;
            icon.paintIcon(c, g, this.myXShift + x + this.myHShifts[i], this.myYShift + y + this.myVShifts[i]);
        }
    }

    public boolean isLayerEnabled(int layer) {
        return !this.myDisabledLayers[layer];
    }

    public void setLayerEnabled(int layer, boolean enabled) {
        this.myDisabledLayers[layer] = !enabled;
    }

    @Override
    public int getIconWidth() {
        return this.myWidth;
    }

    @Override
    public int getIconHeight() {
        return this.myHeight;
    }

    private void recalculateSize() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int i = 0; i < this.myIcons.length; ++i) {
            Icon icon = this.myIcons[i];
            if (icon == null) continue;
            int hShift = this.myHShifts[i];
            int vShift = this.myVShifts[i];
            minX = Math.min(minX, hShift);
            maxX = Math.max(maxX, hShift + icon.getIconWidth());
            minY = Math.min(minY, vShift);
            maxY = Math.max(maxY, vShift + icon.getIconHeight());
        }
        this.myWidth = maxX - minX;
        this.myHeight = maxY - minY;
        if (this.myIcons.length > 1) {
            this.myXShift = -minX;
            this.myYShift = -minY;
        }
    }

    public static Icon create(Icon backgroundIcon, Icon foregroundIcon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(backgroundIcon, 0);
        layeredIcon.setIcon(foregroundIcon, 1);
        return layeredIcon;
    }
}

