/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ActiveComponent;
import com.intellij.ui.Gray;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class CaptionPanel
extends JPanel {
    private static final Color CNT_COLOR = Gray._240;
    private static final Color BND_COLOR = Gray._240;
    public static final Color CNT_ACTIVE_COLOR = Gray._202;
    public static final Color BND_ACTIVE_COLOR = Gray._239;
    private boolean myActive = false;
    private ActiveComponent myButtonComponent;
    private JComponent mySettingComponent;

    public CaptionPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 4, 0, 4));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.myActive) {
            g.setColor(Color.white);
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(Color.gray);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, BND_ACTIVE_COLOR, 0.0f, this.getHeight(), CNT_ACTIVE_COLOR));
        } else {
            g.setColor(Color.white);
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(Color.lightGray);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, BND_COLOR, 0.0f, this.getHeight(), CNT_COLOR));
        }
        g2d.fillRect(0, 1, this.getWidth(), this.getHeight() - 2);
    }

    public void setActive(boolean active) {
        this.myActive = active;
        if (this.myButtonComponent != null) {
            this.myButtonComponent.setActive(active);
        }
        this.repaint();
    }

    public void setButtonComponent(@NotNull ActiveComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/CaptionPanel.setButtonComponent must not be null");
        }
        if (this.myButtonComponent != null) {
            this.remove(this.myButtonComponent.getComponent());
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(" "), "West");
        panel.add((Component)component.getComponent(), "Center");
        panel.setOpaque(false);
        this.add((Component)panel, "East");
        this.myButtonComponent = component;
    }

    public void addSettingsComponent(Component component) {
        if (this.mySettingComponent == null) {
            this.mySettingComponent = new JPanel(new FlowLayout());
            this.mySettingComponent.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.add((Component)this.mySettingComponent, "West");
            this.mySettingComponent.setOpaque(false);
        }
        this.mySettingComponent.add(component);
    }

    public boolean isWithinPanel(MouseEvent e) {
        Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), this);
        Component c = this.findComponentAt(p);
        return c != null && c != this.myButtonComponent;
    }

    public static Color getBorderColor(boolean isActive) {
        return isActive ? Color.gray : Color.lightGray;
    }
}

