/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignatureBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;

public class MethodSignatureBackedByPsiMethod
extends MethodSignatureBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.MethodSignatureBackedByPsiMethod");
    private final PsiMethod myMethod;
    private final boolean myIsRaw;

    protected MethodSignatureBackedByPsiMethod(@NotNull PsiMethod method, PsiSubstitutor substitutor, boolean isRaw, PsiType[] parameterTypes, PsiTypeParameter[] methodTypeParameters) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBackedByPsiMethod.<init> must not be null");
        }
        super(substitutor, parameterTypes, methodTypeParameters);
        this.myIsRaw = isRaw;
        if (!method.isValid()) {
            LOG.error("Invalid method: " + method);
        }
        this.myMethod = method;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myMethod.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureBackedByPsiMethod.getName must not return null");
        }
        return string;
    }

    @Override
    public boolean isRaw() {
        return this.myIsRaw;
    }

    @Override
    public boolean isConstructor() {
        return this.myMethod.isConstructor();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MethodSignatureBackedByPsiMethod && ((MethodSignatureBackedByPsiMethod)o).myMethod == this.myMethod) {
            return true;
        }
        return super.equals(o);
    }

    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureBackedByPsiMethod.getMethod must not return null");
        }
        return psiMethod;
    }

    public static MethodSignatureBackedByPsiMethod create(PsiMethod method, PsiSubstitutor substitutor) {
        return MethodSignatureBackedByPsiMethod.create(method, substitutor, PsiUtil.isRawSubstitutor(method, substitutor));
    }

    public static MethodSignatureBackedByPsiMethod create(PsiMethod method, PsiSubstitutor substitutor, boolean isRaw) {
        PsiTypeParameter[] methodTypeParameters = method.getTypeParameters();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiType[] parameterTypes = new PsiType[parameters.length];
        if (isRaw) {
            substitutor = JavaPsiFacade.getInstance(method.getProject()).getElementFactory().createRawSubstitutor(substitutor, methodTypeParameters);
            methodTypeParameters = PsiTypeParameter.EMPTY_ARRAY;
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypes[i] = TypeConversionUtil.erasure(substitutor.substitute(parameters[i].getType()));
            }
        } else {
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypes[i] = parameters[i].getType();
            }
        }
        return new MethodSignatureBackedByPsiMethod(method, substitutor, isRaw, parameterTypes, methodTypeParameters);
    }
}

