/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static boolean isInheritor(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep) {
        if (candidateClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.isInheritor must not be null");
        }
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.isInheritor must not be null");
        }
        return candidateClass.isInheritor(baseClass, checkDeep);
    }

    public static boolean isInheritorOrSelf(@Nullable PsiClass aClass, @Nullable PsiClass baseClass, boolean checkDeep) {
        if (aClass == null || baseClass == null) {
            return false;
        }
        PsiManager manager = aClass.getManager();
        return manager.areElementsEquivalent(baseClass, aClass) || aClass.isInheritor(baseClass, checkDeep);
    }

    public static boolean isCorrectDescendant(@Nullable PsiClass aClass, @Nullable PsiClass baseClass, boolean checkDeep) {
        return InheritanceUtil.isInheritorOrSelf(aClass, baseClass, checkDeep);
    }

    public static boolean processSupers(@Nullable PsiClass aClass, boolean includeSelf, Processor<PsiClass> superProcessor) {
        if (aClass == null) {
            return true;
        }
        if (includeSelf && !superProcessor.process(aClass)) {
            return false;
        }
        return InheritanceUtil.processSupers(aClass, superProcessor, (Set<PsiClass>)new THashSet());
    }

    private static boolean processSupers(@NotNull PsiClass aClass, Processor<PsiClass> superProcessor, Set<PsiClass> visited) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.processSupers must not be null");
        }
        if (!visited.add(aClass)) {
            return true;
        }
        for (PsiClass intf : aClass.getInterfaces()) {
            if (superProcessor.process(intf) && InheritanceUtil.processSupers(intf, superProcessor, visited)) continue;
            return false;
        }
        PsiClass superClass = aClass.getSuperClass();
        return superClass == null || superProcessor.process(superClass) && InheritanceUtil.processSupers(superClass, superProcessor, visited);
    }

    public static boolean isInheritor(@Nullable PsiType type, @NotNull @NonNls String baseClassName) {
        if (baseClassName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.isInheritor must not be null");
        }
        if (type instanceof PsiClassType) {
            return InheritanceUtil.isInheritor(((PsiClassType)type).resolve(), baseClassName);
        }
        return false;
    }

    public static boolean isInheritor(@Nullable PsiClass psiClass, String baseClassName) {
        return InheritanceUtil.isInheritor(psiClass, false, baseClassName);
    }

    public static boolean isInheritor(@Nullable PsiClass psiClass, boolean strict, String baseClassName) {
        if (psiClass == null) {
            return false;
        }
        PsiClass base = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(baseClassName, psiClass.getResolveScope());
        if (base == null) {
            return false;
        }
        return strict ? psiClass.isInheritor(base, true) : InheritanceUtil.isInheritorOrSelf(psiClass, base, true);
    }

    public static void getSuperClasses(PsiClass aClass, Set<PsiClass> results, boolean includeNonProject) {
        InheritanceUtil.getSuperClassesOfList(aClass.getSuperTypes(), results, includeNonProject);
    }

    public static void getSuperClassesOfList(PsiClassType[] types, Set<PsiClass> results, boolean includeNonProject) {
        for (PsiClassType type : types) {
            PsiClass resolved = type.resolve();
            if (resolved == null || results.contains(resolved)) continue;
            if (includeNonProject || resolved.getManager().isInProject(resolved)) {
                results.add(resolved);
            }
            InheritanceUtil.getSuperClasses(resolved, results, includeNonProject);
        }
    }
}

