/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IElementType {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.tree.IElementType");
    public static final short FIRST_TOKEN_INDEX = 1;
    private static short ourCounter = 1;
    private static final short MAX_INDEXED_TYPES = 10000;
    private static final List<IElementType> ourRegistry = new ArrayList<IElementType>(700);
    private final short myIndex;
    public static final Predicate TRUE = new Predicate(){

        @Override
        public boolean matches(IElementType type) {
            return true;
        }
    };
    public static final IElementType[] EMPTY_ARRAY = new IElementType[0];
    private final String myDebugName;
    @NotNull
    private final Language myLanguage;

    static int getAllocatedTypesCount() {
        return ourCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IElementType[] enumerate(Predicate p) {
        IElementType[] copy;
        ArrayList<IElementType> matches = new ArrayList<IElementType>();
        List<IElementType> list = ourRegistry;
        synchronized (list) {
            copy = ourRegistry.toArray(new IElementType[ourRegistry.size()]);
        }
        for (IElementType value : copy) {
            if (!p.matches(value)) continue;
            matches.add(value);
        }
        return matches.toArray(new IElementType[matches.size()]);
    }

    public IElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/tree/IElementType.<init> must not be null");
        }
        this(debugName, language, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IElementType(String debugName, Language language, boolean register) {
        this.myDebugName = debugName;
        Language language2 = this.myLanguage = language == null ? Language.ANY : language;
        if (register) {
            short s = ourCounter;
            ourCounter = (short)(s + 1);
            this.myIndex = s;
            LOG.assertTrue(ourCounter < 10000, "Too many element types registered. Out of (short) range.");
            List<IElementType> list = ourRegistry;
            synchronized (list) {
                ourRegistry.add(this);
            }
        } else {
            this.myIndex = (short)-1;
        }
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/tree/IElementType.getLanguage must not return null");
        }
        return language;
    }

    public final short getIndex() {
        return this.myIndex;
    }

    public String toString() {
        return this.myDebugName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IElementType find(short idx) {
        List<IElementType> list = ourRegistry;
        synchronized (list) {
            if (idx == 0) {
                return ourRegistry.get(0);
            }
            return ourRegistry.get(idx - 1);
        }
    }

    public boolean isLeftBound() {
        return false;
    }

    public static interface Predicate {
        public boolean matches(IElementType var1);
    }
}

