/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class ProjectScopeImpl
extends GlobalSearchScope {
    private final FileIndexFacade myFileIndex;

    public ProjectScopeImpl(Project project, FileIndexFacade fileIndex) {
        super(project);
        this.myFileIndex = fileIndex;
    }

    @Override
    public boolean contains(VirtualFile file) {
        if (file instanceof VirtualFileWindow) {
            return true;
        }
        if (this.myFileIndex.isInLibraryClasses(file) && !this.myFileIndex.isInSourceContent(file)) {
            return false;
        }
        return this.myFileIndex.isInContent(file);
    }

    @Override
    public int compare(VirtualFile file1, VirtualFile file2) {
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectScopeImpl.isSearchInModuleContent must not be null");
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    @Override
    public String getDisplayName() {
        return PsiBundle.message("psi.search.scope.project", new Object[0]);
    }

    public String toString() {
        return this.getDisplayName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        GlobalSearchScope globalSearchScope;
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectScopeImpl.uniteWith must not be null");
        }
        if (scope == this || !scope.isSearchInLibraries() || !scope.isSearchOutsideRootModel()) {
            globalSearchScope = this;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectScopeImpl.uniteWith must not return null");
            return globalSearchScope;
        }
        globalSearchScope = super.uniteWith(scope);
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectScopeImpl.uniteWith must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        GlobalSearchScope globalSearchScope;
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectScopeImpl.intersectWith must not be null");
        }
        if (scope == this) {
            globalSearchScope = this;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectScopeImpl.intersectWith must not return null");
            return globalSearchScope;
        }
        if (!scope.isSearchInLibraries()) {
            globalSearchScope = scope;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectScopeImpl.intersectWith must not return null");
            return globalSearchScope;
        }
        globalSearchScope = super.intersectWith(scope);
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectScopeImpl.intersectWith must not return null");
    }
}

