/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import org.jetbrains.annotations.NotNull;

public class ProjectScope {
    private static final Key<GlobalSearchScope> ALL_SCOPE_KEY = new Key("ALL_SCOPE_KEY");
    private static final Key<GlobalSearchScope> PROJECT_SCOPE_KEY = new Key("PROJECT_SCOPE_KEY");
    private static final Key<GlobalSearchScope> LIBRARIES_SCOPE_KEY = new Key("LIBRARIES_SCOPE_KEY");
    private static final Key<GlobalSearchScope> CONTENT_SCOPE_KEY = new Key("CONTENT_SCOPE_KEY");

    private ProjectScope() {
    }

    @NotNull
    public static GlobalSearchScope getAllScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectScope.getAllScope must not be null");
        }
        GlobalSearchScope cached = project.getUserData(ALL_SCOPE_KEY);
        GlobalSearchScope globalSearchScope = cached != null ? cached : ((UserDataHolderEx)((Object)project)).putUserDataIfAbsent(ALL_SCOPE_KEY, ProjectScopeBuilder.getInstance(project).buildAllScope());
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectScope.getAllScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getProjectScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectScope.getProjectScope must not be null");
        }
        GlobalSearchScope cached = project.getUserData(PROJECT_SCOPE_KEY);
        GlobalSearchScope globalSearchScope = cached != null ? cached : ((UserDataHolderEx)((Object)project)).putUserDataIfAbsent(PROJECT_SCOPE_KEY, ProjectScopeBuilder.getInstance(project).buildProjectScope());
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectScope.getProjectScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getLibrariesScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectScope.getLibrariesScope must not be null");
        }
        GlobalSearchScope cached = project.getUserData(LIBRARIES_SCOPE_KEY);
        GlobalSearchScope globalSearchScope = cached != null ? cached : ((UserDataHolderEx)((Object)project)).putUserDataIfAbsent(LIBRARIES_SCOPE_KEY, ProjectScopeBuilder.getInstance(project).buildLibrariesScope());
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectScope.getLibrariesScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getContentScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectScope.getContentScope must not be null");
        }
        GlobalSearchScope cached = project.getUserData(LIBRARIES_SCOPE_KEY);
        GlobalSearchScope globalSearchScope = cached != null ? cached : ((UserDataHolderEx)((Object)project)).putUserDataIfAbsent(CONTENT_SCOPE_KEY, ProjectScopeBuilder.getInstance(project).buildContentScope());
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectScope.getContentScope must not return null");
        }
        return globalSearchScope;
    }
}

