/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class JavaMethodsConflictResolver
implements PsiConflictResolver {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver");
    private final PsiElement myArgumentsList;
    private final PsiType[] myActualParameterTypes;

    public JavaMethodsConflictResolver(PsiExpressionList list) {
        this.myArgumentsList = list;
        this.myActualParameterTypes = list.getExpressionTypes();
    }

    public JavaMethodsConflictResolver(PsiElement argumentsList, PsiType[] actualParameterTypes) {
        this.myArgumentsList = argumentsList;
        this.myActualParameterTypes = actualParameterTypes;
    }

    @Override
    public CandidateInfo resolveConflict(List<CandidateInfo> conflicts) {
        if (conflicts.isEmpty()) {
            return null;
        }
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        boolean atLeastOneMatch = JavaMethodsConflictResolver.checkParametersNumber(conflicts, this.myActualParameterTypes.length, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkSameSignatures(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessLevels(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkParametersNumber(conflicts, this.myActualParameterTypes.length, false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        int applicabilityLevel = JavaMethodsConflictResolver.checkApplicability(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (!atLeastOneMatch) {
            return null;
        }
        this.checkSpecifics(conflicts, applicabilityLevel);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkPrimitiveVarargs(conflicts, this.myActualParameterTypes.length);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        THashSet uniques = new THashSet(conflicts);
        if (uniques.size() == 1) {
            return (CandidateInfo)uniques.iterator().next();
        }
        return null;
    }

    private void checkSpecifics(List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel) {
        boolean applicable = applicabilityLevel > 1;
        int conflictsCount = conflicts.size();
        if (applicable) {
            CandidateInfo[] newConflictsArray = conflicts.toArray(new CandidateInfo[conflicts.size()]);
            for (int i = 1; i < conflictsCount; ++i) {
                CandidateInfo method = newConflictsArray[i];
                block5: for (int j = 0; j < i; ++j) {
                    CandidateInfo conflict = newConflictsArray[j];
                    assert (conflict != method);
                    switch (this.isMoreSpecific(method, conflict, applicabilityLevel)) {
                        case FIRST: {
                            conflicts.remove(conflict);
                            continue block5;
                        }
                        case SECOND: {
                            conflicts.remove(method);
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    private static void checkAccessLevels(List<CandidateInfo> conflicts) {
        int conflictsCount = conflicts.size();
        int maxCheckLevel = -1;
        int[] checkLevels = new int[conflictsCount];
        int index = 0;
        for (CandidateInfo conflict : conflicts) {
            MethodCandidateInfo method = (MethodCandidateInfo)conflict;
            int level = JavaMethodsConflictResolver.getCheckLevel(method);
            checkLevels[index++] = level;
            maxCheckLevel = Math.max(maxCheckLevel, level);
        }
        for (int i = conflictsCount - 1; i >= 0; --i) {
            if (checkLevels[i] >= maxCheckLevel) continue;
            conflicts.remove(i);
        }
    }

    private static void checkSameSignatures(List<CandidateInfo> conflicts) {
        HashMap<MethodSignature, CandidateInfo> signatures = new HashMap<MethodSignature, CandidateInfo>();
        block0: for (int i = 0; i < conflicts.size(); ++i) {
            CandidateInfo info = conflicts.get(i);
            PsiMethod method = (PsiMethod)info.getElement();
            assert (method != null);
            if (!method.hasModifierProperty("static")) {
                for (int k = i - 1; k >= 0; --k) {
                    PsiMethod existingMethod = (PsiMethod)conflicts.get(k).getElement();
                    if (!PsiSuperMethodImplUtil.isSuperMethodSmart(existingMethod, method)) continue;
                    conflicts.remove(i);
                    --i;
                    continue block0;
                }
            }
            PsiClass class1 = method.getContainingClass();
            PsiSubstitutor infoSubstitutor = info.getSubstitutor();
            MethodSignature signature = method.getSignature(infoSubstitutor);
            CandidateInfo existing = (CandidateInfo)signatures.get(signature);
            if (existing == null) {
                signatures.put(signature, info);
                continue;
            }
            PsiMethod existingMethod = (PsiMethod)existing.getElement();
            assert (existingMethod != null);
            PsiClass existingClass = existingMethod.getContainingClass();
            if (class1.isInterface() && "java.lang.Object".equals(existingClass.getQualifiedName())) {
                signatures.put(signature, info);
                continue;
            }
            if (method == existingMethod) {
                PsiElement scope1 = info.getCurrentFileResolveScope();
                PsiElement scope2 = existing.getCurrentFileResolveScope();
                if (scope1 instanceof PsiClass && scope2 instanceof PsiClass && PsiTreeUtil.isAncestor(scope1, scope2, true) && !existing.isAccessible()) {
                    signatures.put(signature, info);
                    continue;
                }
            }
            boolean existingTypeParamAgree = JavaMethodsConflictResolver.areTypeParametersAgree(existing);
            boolean infoTypeParamAgree = JavaMethodsConflictResolver.areTypeParametersAgree(info);
            if (existingTypeParamAgree && !infoTypeParamAgree && !PsiSuperMethodImplUtil.isSuperMethodSmart(method, existingMethod)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (!existingTypeParamAgree && infoTypeParamAgree && !PsiSuperMethodImplUtil.isSuperMethodSmart(existingMethod, method)) {
                signatures.put(signature, info);
                int index = conflicts.indexOf(existing);
                conflicts.remove(index);
                --i;
                continue;
            }
            if (!InheritanceUtil.isInheritorOrSelf(class1, existingClass, true) && !InheritanceUtil.isInheritorOrSelf(existingClass, class1, true)) continue;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiParameter[] existingParameters = existingMethod.getParameterList().getParameters();
            int parametersLength = parameters.length;
            for (int i1 = 0; i1 < parametersLength; ++i1) {
                if (!(parameters[i1].getType() instanceof PsiArrayType) || existingParameters[i1].getType() instanceof PsiArrayType) continue;
                signatures.put(signature, info);
                continue block0;
            }
            PsiType returnType1 = method.getReturnType();
            PsiType returnType2 = existingMethod.getReturnType();
            if (returnType1 != null && returnType2 != null && !(returnType1 = infoSubstitutor.substitute(returnType1)).equals(returnType2 = existing.getSubstitutor().substitute(returnType2)) && returnType1.isAssignableFrom(returnType2)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            signatures.put(signature, info);
        }
    }

    private static boolean areTypeParametersAgree(CandidateInfo info) {
        return ((MethodCandidateInfo)info).isApplicable();
    }

    private static boolean checkParametersNumber(List<CandidateInfo> conflicts, int argumentsCount, boolean ignoreIfStaticsProblem) {
        boolean atLeastOneMatch = false;
        TIntArrayList unmatchedIndices = null;
        for (int i = 0; i < conflicts.size(); ++i) {
            CandidateInfo info = conflicts.get(i);
            if (ignoreIfStaticsProblem && !info.isStaticsScopeCorrect()) {
                return true;
            }
            if (!(info instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)info).getElement();
            if (method.isVarArgs()) {
                return true;
            }
            if (method.getParameterList().getParametersCount() == argumentsCount) {
                if (unmatchedIndices != null) {
                    for (int u = unmatchedIndices.size() - 1; u >= 0; --u) {
                        int index = unmatchedIndices.get(u);
                        conflicts.remove(index);
                        --i;
                    }
                    unmatchedIndices = null;
                }
                atLeastOneMatch = true;
                continue;
            }
            if (atLeastOneMatch) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (unmatchedIndices == null) {
                unmatchedIndices = new TIntArrayList(conflicts.size() - i);
            }
            unmatchedIndices.add(i);
        }
        return atLeastOneMatch;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    private static int checkApplicability(List<CandidateInfo> conflicts) {
        int level;
        int maxApplicabilityLevel = 0;
        boolean toFilter = false;
        for (CandidateInfo conflict : conflicts) {
            level = ((MethodCandidateInfo)conflict).getApplicabilityLevel();
            if (maxApplicabilityLevel > 0 && maxApplicabilityLevel != level) {
                toFilter = true;
            }
            if (level <= maxApplicabilityLevel) continue;
            maxApplicabilityLevel = level;
        }
        if (toFilter) {
            Iterator<CandidateInfo> iterator = conflicts.iterator();
            while (iterator.hasNext()) {
                CandidateInfo info = iterator.next();
                level = ((MethodCandidateInfo)info).getApplicabilityLevel();
                if (level >= maxApplicabilityLevel) continue;
                iterator.remove();
            }
        }
        return maxApplicabilityLevel;
    }

    private static int getCheckLevel(MethodCandidateInfo method) {
        boolean visible = method.isAccessible();
        boolean available = method.isStaticsScopeCorrect();
        return (visible ? 1 : 0) << 2 | (available ? 1 : 0) << 1 | (method.getCurrentFileResolveScope() instanceof PsiImportStaticStatement ? 0 : 1);
    }

    private static Specifics checkSubtyping(PsiType type1, PsiType type2, PsiMethod method1, PsiMethod method2) {
        boolean assignable1From2;
        boolean noBoxing = type1 instanceof PsiPrimitiveType == type2 instanceof PsiPrimitiveType;
        boolean allowUncheckedConversion = !method1.hasModifierProperty("static") && !method2.hasModifierProperty("static") || method1.getContainingClass() == method2.getContainingClass();
        boolean assignable2From1 = noBoxing && TypeConversionUtil.isAssignable(type2, type1, allowUncheckedConversion);
        boolean bl = assignable1From2 = noBoxing && TypeConversionUtil.isAssignable(type1, type2, allowUncheckedConversion);
        if (assignable1From2 || assignable2From1) {
            if (assignable1From2 && assignable2From1) {
                return null;
            }
            return assignable1From2 ? Specifics.SECOND : Specifics.FIRST;
        }
        return Specifics.NEITHER;
    }

    private boolean isBoxingHappened(PsiType argType, PsiType parameterType) {
        if (argType == null) {
            return parameterType instanceof PsiPrimitiveType;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(this.myArgumentsList);
        if (parameterType instanceof PsiClassType) {
            parameterType = ((PsiClassType)parameterType).setLanguageLevel(languageLevel);
        }
        return TypeConversionUtil.boxingConversionApplicable(parameterType, argType);
    }

    private Specifics isMoreSpecific(CandidateInfo info1, CandidateInfo info2, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel) {
        PsiMethod method1 = (PsiMethod)info1.getElement();
        PsiMethod method2 = (PsiMethod)info2.getElement();
        PsiClass class1 = method1.getContainingClass();
        PsiClass class2 = method2.getContainingClass();
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        PsiTypeParameter[] typeParameters1 = method1.getTypeParameters();
        PsiTypeParameter[] typeParameters2 = method2.getTypeParameters();
        PsiSubstitutor classSubstitutor1 = info1.getSubstitutor();
        PsiSubstitutor classSubstitutor2 = info2.getSubstitutor();
        PsiSubstitutor methodSubstitutor1 = PsiSubstitutor.EMPTY;
        PsiSubstitutor methodSubstitutor2 = PsiSubstitutor.EMPTY;
        int max = Math.max(params1.length, params2.length);
        PsiType[] types1 = new PsiType[max];
        PsiType[] types2 = new PsiType[max];
        for (int i = 0; i < max; ++i) {
            PsiType type1 = params1[Math.min(i, params1.length - 1)].getType();
            PsiType type2 = params2[Math.min(i, params2.length - 1)].getType();
            if (applicabilityLevel == 2) {
                if (type1 instanceof PsiEllipsisType && type2 instanceof PsiEllipsisType) {
                    type1 = ((PsiEllipsisType)type1).toArrayType();
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                } else {
                    type1 = type1 instanceof PsiEllipsisType ? ((PsiArrayType)type1).getComponentType() : type1;
                    type2 = type2 instanceof PsiEllipsisType ? ((PsiArrayType)type2).getComponentType() : type2;
                }
            }
            types1[i] = type1;
            types2[i] = type2;
        }
        if (typeParameters1.length == 0 || typeParameters2.length == 0) {
            if (typeParameters1.length > 0) {
                PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(this.myArgumentsList.getProject()).getResolveHelper();
                methodSubstitutor1 = this.calculateMethodSubstitutor(typeParameters1, types1, types2, resolveHelper);
            } else if (typeParameters2.length > 0) {
                PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(this.myArgumentsList.getProject()).getResolveHelper();
                methodSubstitutor2 = this.calculateMethodSubstitutor(typeParameters2, types2, types1, resolveHelper);
            }
        } else {
            PsiElementFactory factory = JavaPsiFacade.getInstance(this.myArgumentsList.getProject()).getElementFactory();
            methodSubstitutor1 = factory.createRawSubstitutor(PsiSubstitutor.EMPTY, typeParameters1);
            methodSubstitutor2 = factory.createRawSubstitutor(PsiSubstitutor.EMPTY, typeParameters2);
        }
        int[] boxingHappened = new int[2];
        for (int i = 0; i < types1.length; ++i) {
            PsiType type1 = classSubstitutor1.substitute(methodSubstitutor1.substitute(types1[i]));
            PsiType type2 = classSubstitutor2.substitute(methodSubstitutor2.substitute(types2[i]));
            PsiType argType = i < this.myActualParameterTypes.length ? this.myActualParameterTypes[i] : null;
            boxingHappened[0] = boxingHappened[0] + (this.isBoxingHappened(argType, type1) ? 1 : 0);
            boxingHappened[1] = boxingHappened[1] + (this.isBoxingHappened(argType, type2) ? 1 : 0);
        }
        if (boxingHappened[0] == 0 && boxingHappened[1] > 0) {
            return Specifics.FIRST;
        }
        if (boxingHappened[0] > 0 && boxingHappened[1] == 0) {
            return Specifics.SECOND;
        }
        Specifics isMoreSpecific = null;
        block7: for (int i = 0; i < types1.length; ++i) {
            Specifics specifics;
            PsiType type1 = classSubstitutor1.substitute(methodSubstitutor1.substitute(types1[i]));
            PsiType type2 = classSubstitutor2.substitute(methodSubstitutor2.substitute(types2[i]));
            Specifics specifics2 = specifics = type1 == null || type2 == null ? null : JavaMethodsConflictResolver.checkSubtyping(type1, type2, method1, method2);
            if (specifics == null) continue;
            switch (specifics) {
                case FIRST: {
                    if (isMoreSpecific == Specifics.SECOND) {
                        return Specifics.NEITHER;
                    }
                    isMoreSpecific = specifics;
                    continue block7;
                }
                case SECOND: {
                    if (isMoreSpecific == Specifics.FIRST) {
                        return Specifics.NEITHER;
                    }
                    isMoreSpecific = specifics;
                    continue block7;
                }
                case NEITHER: {
                    return Specifics.NEITHER;
                }
            }
        }
        if (isMoreSpecific == null && class1 != class2) {
            if (class2.isInheritor(class1, true) || class1.isInterface() && !class2.isInterface()) {
                if (MethodSignatureUtil.isSubsignature(method1.getSignature(info1.getSubstitutor()), method2.getSignature(info2.getSubstitutor()))) {
                    isMoreSpecific = Specifics.SECOND;
                } else if (method1.hasModifierProperty("static") && method2.hasModifierProperty("static")) {
                    isMoreSpecific = Specifics.SECOND;
                }
            } else if (class1.isInheritor(class2, true) || class2.isInterface()) {
                if (MethodSignatureUtil.isSubsignature(method2.getSignature(info2.getSubstitutor()), method1.getSignature(info1.getSubstitutor()))) {
                    isMoreSpecific = Specifics.FIRST;
                } else if (method1.hasModifierProperty("static") && method2.hasModifierProperty("static")) {
                    isMoreSpecific = Specifics.FIRST;
                }
            }
        }
        if (isMoreSpecific == null) {
            if (typeParameters1.length < typeParameters2.length) {
                return Specifics.FIRST;
            }
            if (typeParameters1.length > typeParameters2.length) {
                return Specifics.SECOND;
            }
            return Specifics.NEITHER;
        }
        return isMoreSpecific;
    }

    private PsiSubstitutor calculateMethodSubstitutor(PsiTypeParameter[] typeParameters, PsiType[] types1, PsiType[] types2, PsiResolveHelper resolveHelper) {
        PsiSubstitutor substitutor = resolveHelper.inferTypeArguments(typeParameters, types1, types2, PsiUtil.getLanguageLevel(this.myArgumentsList));
        for (PsiTypeParameter typeParameter : typeParameters) {
            LOG.assertTrue(typeParameter != null);
            if (substitutor.getSubstitutionMap().containsKey(typeParameter)) continue;
            substitutor = substitutor.put(typeParameter, TypeConversionUtil.typeParameterErasure(typeParameter));
        }
        return substitutor;
    }

    public static void checkPrimitiveVarargs(List<CandidateInfo> conflicts, int argumentsCount) {
        PsiType type;
        PsiType componentType;
        PsiMethod method;
        PsiMethod objectVararg = null;
        for (CandidateInfo conflict : conflicts) {
            PsiClassType classType;
            method = (PsiMethod)conflict.getElement();
            int parametersCount = method.getParameterList().getParametersCount();
            if (!method.isVarArgs() || parametersCount - 1 != argumentsCount || !Comparing.equal(componentType = ((PsiArrayType)(type = method.getParameterList().getParameters()[parametersCount - 1].getType())).getComponentType(), classType = PsiType.getJavaLangObject(method.getManager(), GlobalSearchScope.allScope(method.getProject())))) continue;
            objectVararg = method;
        }
        if (objectVararg != null) {
            Iterator<CandidateInfo> iterator = conflicts.iterator();
            while (iterator.hasNext()) {
                CandidateInfo conflict;
                conflict = iterator.next();
                method = (PsiMethod)conflict.getElement();
                if (method == objectVararg || method == null || !method.isVarArgs()) continue;
                int paramsCount = method.getParameterList().getParametersCount();
                type = method.getParameterList().getParameters()[paramsCount - 1].getType();
                componentType = ((PsiArrayType)type).getComponentType();
                if (argumentsCount != paramsCount - 1 || !(componentType instanceof PsiPrimitiveType)) continue;
                iterator.remove();
            }
        }
    }

    private static enum Specifics {
        FIRST,
        SECOND,
        NEITHER;

    }
}

