/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.infos;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nullable;

public class MethodCandidateInfo
extends CandidateInfo {
    @ApplicabilityLevelConstant
    private int myApplicabilityLevel = 0;
    private final PsiElement myArgumentList;
    private final PsiType[] myArgumentTypes;
    private final PsiType[] myTypeArguments;
    private PsiSubstitutor myCalcedSubstitutor = null;
    private final LanguageLevel myLanguageLevel;

    public MethodCandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement argumentList, PsiElement currFileContext, @Nullable PsiType[] argumentTypes, PsiType[] typeArguments) {
        this(candidate, substitutor, accessProblem, staticsProblem, argumentList, currFileContext, argumentTypes, typeArguments, PsiUtil.getLanguageLevel(argumentList));
    }

    public MethodCandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement argumentList, PsiElement currFileContext, @Nullable PsiType[] argumentTypes, PsiType[] typeArguments, LanguageLevel languageLevel) {
        super(candidate, substitutor, accessProblem, staticsProblem, currFileContext);
        this.myArgumentList = argumentList;
        this.myArgumentTypes = argumentTypes;
        this.myTypeArguments = typeArguments;
        this.myLanguageLevel = languageLevel;
    }

    public boolean isApplicable() {
        return this.getApplicabilityLevel() != 1;
    }

    @ApplicabilityLevelConstant
    private int getApplicabilityLevelInner() {
        if (this.myArgumentTypes == null) {
            return 1;
        }
        int level = PsiUtil.getApplicabilityLevel(this.getElement(), this.getSubstitutor(), this.myArgumentTypes, this.myLanguageLevel);
        if (level > 1 && !this.isTypeArgumentsApplicable()) {
            level = 1;
        }
        return level;
    }

    @ApplicabilityLevelConstant
    public int getApplicabilityLevel() {
        if (this.myApplicabilityLevel == 0) {
            this.myApplicabilityLevel = this.getApplicabilityLevelInner();
        }
        return this.myApplicabilityLevel;
    }

    @Override
    public PsiSubstitutor getSubstitutor() {
        if (this.myCalcedSubstitutor == null) {
            PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
            PsiMethod method = this.getElement();
            if (this.myTypeArguments == null) {
                this.myCalcedSubstitutor = this.inferTypeArguments(DefaultParameterTypeInferencePolicy.INSTANCE);
            } else {
                PsiTypeParameter[] typeParams = method.getTypeParameters();
                for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                    incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
                }
                this.myCalcedSubstitutor = incompleteSubstitutor;
            }
        }
        return this.myCalcedSubstitutor;
    }

    public boolean isTypeArgumentsApplicable() {
        PsiTypeParameter[] typeParams = this.getElement().getTypeParameters();
        if (this.myTypeArguments != null && typeParams.length != this.myTypeArguments.length) {
            return false;
        }
        PsiSubstitutor substitutor = this.getSubstitutor();
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, substitutor, this.myArgumentList.getParent());
    }

    @Override
    public boolean isValidResult() {
        return super.isValidResult() && this.isApplicable();
    }

    @Override
    public PsiMethod getElement() {
        return (PsiMethod)super.getElement();
    }

    public PsiSubstitutor inferTypeArguments(ParameterTypeInferencePolicy policy) {
        return this.inferTypeArguments(policy, this.myArgumentList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentList).getExpressions() : PsiExpression.EMPTY_ARRAY);
    }

    public PsiSubstitutor inferTypeArguments(ParameterTypeInferencePolicy policy, PsiExpression[] arguments) {
        PsiClass containingClass;
        PsiMethod method = this.getElement();
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(method.getProject());
        if (!method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && PsiUtil.isRawSubstitutor(containingClass, this.mySubstitutor)) {
            return javaPsiFacade.getElementFactory().createRawSubstitutor(this.mySubstitutor, typeParameters);
        }
        return javaPsiFacade.getResolveHelper().inferTypeArguments(typeParameters, method.getParameterList().getParameters(), arguments, this.mySubstitutor, this.myArgumentList.getParent(), policy);
    }

    public boolean isInferencePossible() {
        return this.myArgumentList.isValid();
    }

    public static @interface ApplicabilityLevelConstant {
    }

    public static class ApplicabilityLevel {
        public static final int NOT_APPLICABLE = 1;
        public static final int VARARGS = 2;
        public static final int FIXED_ARITY = 3;
    }
}

