/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiPrefixExpressionImpl
extends ExpressionPsiElement
implements PsiPrefixExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiPrefixExpressionImpl");

    public PsiPrefixExpressionImpl() {
        super(JavaElementType.PREFIX_EXPRESSION);
    }

    @Override
    public PsiExpression getOperand() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(67);
    }

    @Override
    @NotNull
    public PsiJavaToken getOperationSign() {
        PsiJavaToken psiJavaToken = (PsiJavaToken)this.findChildByRoleAsPsiElement(63);
        if (psiJavaToken == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiPrefixExpressionImpl.getOperationSign must not return null");
        }
        return psiJavaToken;
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = this.getOperationSign().getTokenType();
        if (iElementType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiPrefixExpressionImpl.getOperationTokenType must not return null");
        }
        return iElementType;
    }

    @Override
    public PsiType getType() {
        IElementType opCode;
        PsiExpression operand = this.getOperand();
        if (operand == null) {
            return null;
        }
        PsiType type = operand.getType();
        if (type instanceof PsiClassType) {
            type = PsiPrimitiveType.getUnboxedType(type);
        }
        if ((opCode = this.getOperationTokenType()) == JavaTokenType.PLUS || opCode == JavaTokenType.MINUS || opCode == JavaTokenType.TILDE) {
            if (type == null) {
                return null;
            }
            return PsiType.BYTE.equals(type) || PsiType.CHAR.equals(type) || PsiType.SHORT.equals(type) ? PsiType.INT : type;
        }
        if (opCode == JavaTokenType.PLUSPLUS || opCode == JavaTokenType.MINUSMINUS) {
            return type;
        }
        if (opCode == JavaTokenType.EXCL) {
            return PsiType.BOOLEAN;
        }
        LOG.assertTrue(false);
        return null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 63: {
                return this.getFirstChildNode();
            }
            case 67: 
        }
        return ElementType.EXPRESSION_BIT_SET.contains(this.getLastChildNode().getElementType()) ? this.getLastChildNode() : null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (child == this.getFirstChildNode()) {
            return 63;
        }
        if (child == this.getLastChildNode() && ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 67;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiPrefixExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPrefixExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiPrefixExpression:" + this.getText();
    }
}

