/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCatchSectionImpl
extends CompositePsiElement
implements PsiCatchSection,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiCatchSectionImpl");
    private CachedValue<List<PsiType>> myTypesCache = null;

    public PsiCatchSectionImpl() {
        super(CATCH_SECTION);
    }

    @Override
    public PsiParameter getParameter() {
        return (PsiParameter)this.findChildByRoleAsPsiElement(15);
    }

    @Override
    public PsiCodeBlock getCatchBlock() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(49);
    }

    @Override
    public PsiType getCatchType() {
        PsiParameter parameter = this.getParameter();
        if (parameter == null) {
            return null;
        }
        return parameter.getType();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public List<PsiType> getPreciseCatchTypes() {
        List<PsiType> list;
        PsiParameter parameter = this.getParameter();
        if (parameter == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl.getPreciseCatchTypes must not return null");
            return list;
        }
        list = this.getTypesCache().getValue();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl.getPreciseCatchTypes must not return null");
    }

    private synchronized CachedValue<List<PsiType>> getTypesCache() {
        if (this.myTypesCache == null) {
            CachedValuesManager cacheManager = CachedValuesManager.getManager(this.getProject());
            this.myTypesCache = cacheManager.createCachedValue(new CachedValueProvider<List<PsiType>>(){

                @Override
                public CachedValueProvider.Result<List<PsiType>> compute() {
                    List types = PsiCatchSectionImpl.this.computePreciseCatchTypes(PsiCatchSectionImpl.this.getParameter());
                    return CachedValueProvider.Result.create(types, PsiModificationTracker.MODIFICATION_COUNT);
                }
            }, false);
        }
        return this.myTypesCache;
    }

    private List<PsiType> computePreciseCatchTypes(final PsiParameter parameter) {
        PsiCodeBlock tryBlock;
        PsiType declaredType = parameter.getType();
        LanguageLevel level = PsiUtil.getLanguageLevel(parameter);
        if (level.isAtLeast(LanguageLevel.JDK_1_7) && PsiCatchSectionImpl.isCatchParameterEffectivelyFinal(parameter, this.getCatchBlock()) && (tryBlock = this.getTryStatement().getTryBlock()) != null) {
            final List<PsiClassType> thrownTypes = ExceptionUtil.getThrownExceptions(tryBlock);
            final PsiParameter[] parameters = this.getTryStatement().getCatchBlockParameters();
            List<PsiType> uncaughtTypes = ContainerUtil.mapNotNull(thrownTypes, new NullableFunction<PsiClassType, PsiType>(){

                @Override
                public PsiType fun(PsiClassType thrownType) {
                    for (int i = 0; i < parameters.length && parameters[i] != parameter && thrownTypes.size() > 0; ++i) {
                        PsiType catchType = parameters[i].getType();
                        if (!catchType.isAssignableFrom(thrownType)) continue;
                        return null;
                    }
                    return thrownType;
                }
            });
            boolean passed = true;
            for (PsiType type : uncaughtTypes) {
                if (declaredType.isAssignableFrom(type)) continue;
                passed = false;
                break;
            }
            if (passed) {
                return uncaughtTypes;
            }
        }
        return Arrays.asList(declaredType);
    }

    private static boolean isCatchParameterEffectivelyFinal(final PsiParameter parameter, PsiCodeBlock catchBlock) {
        final boolean[] result = new boolean[]{true};
        if (catchBlock != null) {
            catchBlock.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                    PsiExpression left = expression.getLExpression();
                    if (left instanceof PsiReferenceExpression && parameter.equals(((PsiReferenceExpression)left).resolve())) {
                        result[0] = false;
                        this.stopWalking();
                    }
                }
            });
        }
        return result[0];
    }

    @Override
    @NotNull
    public PsiTryStatement getTryStatement() {
        PsiTryStatement psiTryStatement = (PsiTryStatement)this.getParent();
        if (psiTryStatement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl.getTryStatement must not return null");
        }
        return psiTryStatement;
    }

    @Override
    @Nullable
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)((Object)this.findChildByRole(50));
    }

    @Override
    @Nullable
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)((Object)this.findChildByRole(51));
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitCatchSection(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiCatchSection";
    }

    @Override
    public ASTNode findChildByRole(int role) {
        switch (role) {
            default: {
                return null;
            }
            case 15: {
                return this.findChildByType(PARAMETER);
            }
            case 46: {
                return this.findChildByType(CATCH_KEYWORD);
            }
            case 50: {
                return this.findChildByType(LPARENTH);
            }
            case 51: {
                return this.findChildByType(RPARENTH);
            }
            case 49: 
        }
        return this.findChildByType(CODE_BLOCK);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == PARAMETER) {
            return 15;
        }
        if (i == CODE_BLOCK) {
            return 49;
        }
        if (i == CATCH_KEYWORD) {
            return 46;
        }
        if (i == LPARENTH) {
            return 50;
        }
        if (i == RPARENTH) {
            return 51;
        }
        return 0;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl.processDeclarations must not be null");
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        if (lastParent == null || lastParent.getParent() != this) {
            return true;
        }
        PsiParameter catchParameter = this.getParameter();
        if (catchParameter != null) {
            return processor.execute(catchParameter, state);
        }
        return PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place);
    }
}

