/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReceiver;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAnnotationImpl
extends JavaStubPsiElement<PsiAnnotationStub>
implements PsiAnnotation {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl");
    private static final PairFunction<Project, String, PsiAnnotation> ANNOTATION_CREATOR = new PairFunction<Project, String, PsiAnnotation>(){

        @Override
        public PsiAnnotation fun(Project project, String text) {
            return JavaPsiFacade.getInstance(project).getElementFactory().createAnnotationFromText(text, null);
        }
    };

    public PsiAnnotationImpl(PsiAnnotationStub stub) {
        super(stub, JavaStubElementTypes.ANNOTATION);
    }

    public PsiAnnotationImpl(ASTNode node) {
        super(node);
    }

    @Override
    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
        if (stub != null) {
            return (PsiJavaCodeReferenceElement)stub.getTreeElement().findChildByRoleAsPsiElement(119);
        }
        PsiJavaCodeReferenceElement result = PsiTreeUtil.getChildOfType(this, PsiJavaCodeReferenceElement.class);
        if (result != null && !(result instanceof PsiJavaCodeReferenceElement)) {
            throw new AssertionError((Object)("getChildOfType returned rubbish: " + result));
        }
        return result;
    }

    @Override
    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Override
    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    @Override
    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, @Nullable T value) {
        return (T)PsiImplUtil.setDeclaredAttributeValue(this, attributeName, value, ANNOTATION_CREATOR);
    }

    @Override
    public String toString() {
        return "PsiAnnotation";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        PsiAnnotationParameterList psiAnnotationParameterList;
        PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
        if (stub != null) {
            psiAnnotationParameterList = (PsiAnnotationParameterList)stub.getTreeElement().findChildByRoleAsPsiElement(14);
            if (psiAnnotationParameterList == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl.getParameterList must not return null");
            return psiAnnotationParameterList;
        }
        psiAnnotationParameterList = PsiTreeUtil.getRequiredChildOfType(this, PsiAnnotationParameterList.class);
        if (psiAnnotationParameterList != null) return psiAnnotationParameterList;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl.getParameterList must not return null");
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        PsiJavaCodeReferenceElement nameRef = this.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        return nameRef.getCanonicalText();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotation(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiMetaData getMetaData() {
        return MetaRegistry.getMetaBase(this);
    }

    @Override
    public PsiAnnotationOwner getOwner() {
        PsiElement parent = this.getParent();
        if (parent instanceof PsiTypeElement) {
            return ((PsiTypeElement)parent).getOwner(this);
        }
        if (parent instanceof PsiMethodReceiver || parent instanceof PsiTypeParameter) {
            return (PsiAnnotationOwner)((Object)parent);
        }
        PsiElement member = parent.getParent();
        String[] elementTypeFields = PsiAnnotationImpl.getApplicableElementTypeFields(member);
        if (elementTypeFields == null) {
            return null;
        }
        if (parent instanceof PsiAnnotationOwner && PsiAnnotationImpl.isAnnotationApplicableTo(this, true, elementTypeFields)) {
            return (PsiAnnotationOwner)((Object)parent);
        }
        PsiAnnotationOwner typeElement = member instanceof PsiVariable ? ((PsiVariable)member).getTypeElement() : (member instanceof PsiMethod && !((PsiMethod)member).isConstructor() ? ((PsiMethod)member).getReturnTypeElement() : (parent instanceof PsiAnnotationOwner ? (PsiAnnotationOwner)((Object)parent) : null));
        return typeElement;
    }

    public static boolean isAnnotationApplicableTo(PsiAnnotation annotation, boolean strict, String ... elementTypeFields) {
        if (elementTypeFields == null) {
            return true;
        }
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return !strict;
        }
        PsiElement resolved = nameRef.resolve();
        if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) {
            return !strict;
        }
        PsiClass annotationType = (PsiClass)resolved;
        PsiAnnotation target = annotationType.getModifierList().findAnnotation("java.lang.annotation.Target");
        if (target == null) {
            return !strict;
        }
        PsiNameValuePair[] attributes = target.getParameterList().getAttributes();
        if (attributes.length == 0) {
            return !strict;
        }
        PsiAnnotationMemberValue value = attributes[0].getValue();
        LOG.assertTrue(elementTypeFields.length > 0);
        PsiManager manager = annotation.getManager();
        PsiClass elementTypeClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.annotation.ElementType", annotation.getResolveScope());
        if (elementTypeClass == null) {
            return !strict;
        }
        for (String fieldName : elementTypeFields) {
            PsiField field = elementTypeClass.findFieldByName(fieldName, false);
            if (field == null) continue;
            if (value instanceof PsiArrayInitializerMemberValue) {
                PsiAnnotationMemberValue[] initializers;
                for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                    PsiReferenceExpression refExpr;
                    if (!(initializer instanceof PsiReferenceExpression) || !(refExpr = (PsiReferenceExpression)initializer).isReferenceTo(field)) continue;
                    return true;
                }
                continue;
            }
            if (!(value instanceof PsiReferenceExpression) || !((PsiReferenceExpression)value).isReferenceTo(field)) continue;
            return true;
        }
        return false;
    }

    public static String[] getApplicableElementTypeFields(PsiElement owner) {
        if (owner instanceof PsiClass) {
            PsiClass aClass = (PsiClass)owner;
            if (aClass.isAnnotationType()) {
                return new String[]{"ANNOTATION_TYPE", "TYPE"};
            }
            if (aClass instanceof PsiTypeParameter) {
                return new String[]{"TYPE_PARAMETER"};
            }
            return new String[]{"TYPE"};
        }
        if (owner instanceof PsiMethod) {
            if (((PsiMethod)owner).isConstructor()) {
                return new String[]{"CONSTRUCTOR"};
            }
            return new String[]{"METHOD"};
        }
        if (owner instanceof PsiField) {
            return new String[]{"FIELD"};
        }
        if (owner instanceof PsiParameter) {
            return new String[]{"PARAMETER"};
        }
        if (owner instanceof PsiLocalVariable) {
            return new String[]{"LOCAL_VARIABLE"};
        }
        if (owner instanceof PsiPackageStatement) {
            return new String[]{"PACKAGE"};
        }
        if (owner instanceof PsiTypeElement) {
            return new String[]{"TYPE_USE"};
        }
        return null;
    }
}

