/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;

public class SourceUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.SourceUtil");

    private SourceUtil() {
    }

    public static String getTextSkipWhiteSpaceAndComments(ASTNode element) {
        return AstBufferUtil.getTextSkippingWhitespaceComments(element);
    }

    public static String getTextSkipWhiteSpaceAndComments(LighterAST tree, LighterASTNode node) {
        return LightTreeUtil.toFilteredString(tree, node, ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET);
    }

    public static TreeElement addParenthToReplacedChild(IElementType parenthType, TreeElement newChild, PsiManager manager) {
        CompositeElement parenthExpr = ASTFactory.composite(parenthType);
        TreeElement dummyExpr = (TreeElement)newChild.clone();
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree(newChild);
        new DummyHolder(manager, parenthExpr, null, charTableByTree);
        parenthExpr.putUserData(CharTable.CHAR_TABLE_KEY, charTableByTree);
        parenthExpr.rawAddChildren(ASTFactory.leaf(JavaTokenType.LPARENTH, "("));
        parenthExpr.rawAddChildren(dummyExpr);
        parenthExpr.rawAddChildren(ASTFactory.leaf(JavaTokenType.RPARENTH, ")"));
        try {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(manager.getProject());
            parenthExpr = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(codeStyleManager.reformat(SourceTreeToPsiMap.treeElementToPsi(parenthExpr)));
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        newChild.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(newChild));
        dummyExpr.rawReplaceWithList(newChild);
        newChild = parenthExpr;
        TreeUtil.clearCaches(TreeUtil.getFileElement(newChild));
        return newChild;
    }
}

