/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.google.common.collect.Lists;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightTreeUtil {
    private LightTreeUtil() {
    }

    @Nullable
    public static LighterASTNode firstChildOfType(LighterAST tree, LighterASTNode node, IElementType type) {
        for (LighterASTNode child : tree.getChildren(node)) {
            if (child.getTokenType() != type) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(LighterAST tree, LighterASTNode node, IElementType type) {
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, type);
        assert (child != null) : "Required child " + type + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        LighterASTNode lighterASTNode = child;
        if (lighterASTNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LightTreeUtil.requiredChildOfType must not return null");
        }
        return lighterASTNode;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(LighterAST tree, LighterASTNode node, IElementType type) {
        ArrayList result = Lists.newArrayList();
        for (LighterASTNode child : tree.getChildren(node)) {
            if (child.getTokenType() != type) continue;
            result.add(child);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LightTreeUtil.getChildrenOfType must not return null");
        }
        return arrayList;
    }

    public static String toFilteredString(LighterAST tree, LighterASTNode node, @Nullable TokenSet skipTypes) {
        StringBuilder buffer = new StringBuilder(node.getEndOffset() - node.getStartOffset());
        LightTreeUtil.toBuffer(tree, node, buffer, skipTypes);
        return buffer.toString();
    }

    private static void toBuffer(LighterAST tree, LighterASTNode node, StringBuilder buffer, @Nullable TokenSet skipTypes) {
        if (skipTypes != null && skipTypes.contains(node.getTokenType())) {
            return;
        }
        if (node instanceof LighterASTTokenNode) {
            buffer.append(((LighterASTTokenNode)node).getText());
            return;
        }
        if (node instanceof LighterLazyParseableNode) {
            buffer.append(((LighterLazyParseableNode)node).getText());
            return;
        }
        for (LighterASTNode child : tree.getChildren(node)) {
            LightTreeUtil.toBuffer(tree, child, buffer, skipTypes);
        }
    }
}

