/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.containers.WeakList;
import com.intellij.util.messages.MessageBus;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaResolveCache {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.JavaResolveCache");
    private static final NotNullLazyKey<JavaResolveCache, Project> INSTANCE_KEY = ServiceManager.createLazyKey(JavaResolveCache.class);
    private final ConcurrentMap<PsiExpression, PsiType> myCalculatedTypes = new ConcurrentWeakHashMap<PsiExpression, PsiType>();
    private final ConcurrentMap<PsiElement, PsiType> myCachedReferencesInPsiTypes = new ConcurrentWeakHashMap<PsiElement, PsiType>();
    private final Map<PsiElement, WeakList<PsiElement>> myCachedReferenceIn_PsiClassReferenceType_To_ListOfReferencesOfThisType_CachedHere = new WeakHashMap<PsiElement, WeakList<PsiElement>>();
    private final Map<PsiVariable, Object> myVarToConstValueMapPhysical = new ConcurrentWeakHashMap<PsiVariable, Object>();
    private final Map<PsiVariable, Object> myVarToConstValueMapNonPhysical = new ConcurrentWeakHashMap<PsiVariable, Object>();
    private static final Object NULL = Key.create("NULL");

    public static JavaResolveCache getInstance(Project project) {
        return INSTANCE_KEY.getValue(project);
    }

    public JavaResolveCache(MessageBus messageBus) {
        if (messageBus != null) {
            messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

                @Override
                public void beforePsiChanged(boolean isPhysical) {
                    JavaResolveCache.this.clearCaches(isPhysical);
                }

                @Override
                public void afterPsiChanged(boolean isPhysical) {
                }
            });
        }
    }

    private void clearCaches(boolean isPhysical) {
        this.myCalculatedTypes.clear();
        this.myCachedReferencesInPsiTypes.clear();
        this.myCachedReferenceIn_PsiClassReferenceType_To_ListOfReferencesOfThisType_CachedHere.clear();
        if (isPhysical) {
            this.myVarToConstValueMapPhysical.clear();
        }
        this.myVarToConstValueMapNonPhysical.clear();
    }

    public boolean isTypeCached(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveCache.isTypeCached must not be null");
        }
        return this.myCalculatedTypes.get(expr) != null;
    }

    @Nullable
    public <T extends PsiExpression> PsiType getType(@NotNull T expr, @NotNull Function<T, PsiType> f) {
        if (expr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveCache.getType must not be null");
        }
        if (f == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveCache.getType must not be null");
        }
        PsiType type = (PsiType)this.myCalculatedTypes.get(expr);
        if (type == null) {
            PsiType stored;
            type = f.fun(expr);
            if (type == null) {
                type = TypeConversionUtil.NULL_TYPE;
            }
            if ((stored = ConcurrencyUtil.cacheOrGet(this.myCalculatedTypes, expr, type)) == type && DebugUtil.DO_EXPENSIVE_CHECKS) {
                this.registerDiagnosticsHooks(expr, type);
            }
            type = stored;
        }
        if (!type.isValid()) {
            if (expr.isValid()) {
                PsiJavaCodeReferenceElement refInside = type instanceof PsiClassReferenceType ? ((PsiClassReferenceType)type).getReference() : null;
                String typeinfo = type + " (" + type.getClass() + ")" + (refInside == null ? "" : "; ref inside: " + refInside + " (" + refInside.getClass() + ") valid:" + refInside.isValid());
                LOG.error("Type is invalid: " + typeinfo + "; expr: '" + expr + "' (" + expr.getClass() + ") is valid");
            } else {
                LOG.error("Expression: '" + expr + "' is invalid, must not be used for getType()");
            }
        }
        return type == TypeConversionUtil.NULL_TYPE ? null : type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PsiExpression> void registerDiagnosticsHooks(T expr, PsiType type) {
        if (type instanceof PsiClassReferenceType) {
            PsiFile physicalFile;
            PsiElement physicalContext;
            PsiJavaCodeReferenceElement reference = ((PsiClassReferenceType)type).getReference();
            ConcurrencyUtil.cacheOrGet(this.myCachedReferencesInPsiTypes, reference, type);
            Map<PsiElement, WeakList<PsiElement>> map = this.myCachedReferenceIn_PsiClassReferenceType_To_ListOfReferencesOfThisType_CachedHere;
            synchronized (map) {
                WeakList<PsiElement> refsTo = this.myCachedReferenceIn_PsiClassReferenceType_To_ListOfReferencesOfThisType_CachedHere.get(reference);
                if (refsTo == null) {
                    refsTo = new WeakList();
                    this.myCachedReferenceIn_PsiClassReferenceType_To_ListOfReferencesOfThisType_CachedHere.put(reference, refsTo);
                }
                refsTo.add(expr);
            }
            final PsiFile dummyHolder = reference.getContainingFile();
            if (dummyHolder != null && !dummyHolder.isPhysical() && (physicalContext = dummyHolder.getContext()) != null && (physicalFile = physicalContext.getContainingFile()) != null && physicalFile.getVirtualFile() != null && !((PsiManagerEx)dummyHolder.getManager()).isAssertOnFileLoading(physicalFile.getVirtualFile())) {
                DebugUtil.trackInvalidation(physicalContext, "dummy holder was invalidated", new Processor<PsiElement>(){

                    @Override
                    public boolean process(PsiElement element) {
                        DebugUtil.onInvalidated((TreeElement)((Object)dummyHolder.getNode()));
                        return true;
                    }
                });
            }
            DebugUtil.trackInvalidation(reference, "Reference inside PsiClassReferenceType was invalidated", new Processor<PsiElement>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean process(PsiElement element) {
                    PsiType cachedRef;
                    PsiType cached = (PsiType)JavaResolveCache.this.myCalculatedTypes.get(element);
                    if (cached != null) {
                        LOG.error(element + " (inside ref) is invalid and yet it is still cached: " + cached);
                    }
                    if ((cachedRef = (PsiType)JavaResolveCache.this.myCachedReferencesInPsiTypes.get(element)) != null) {
                        LOG.error(element + " (inside ref) is invalid and yet it is still cached in ref cache: " + cachedRef);
                    }
                    Map map = JavaResolveCache.this.myCachedReferenceIn_PsiClassReferenceType_To_ListOfReferencesOfThisType_CachedHere;
                    synchronized (map) {
                        WeakList refsTo = (WeakList)JavaResolveCache.this.myCachedReferenceIn_PsiClassReferenceType_To_ListOfReferencesOfThisType_CachedHere.get(element);
                        if (refsTo != null) {
                            for (PsiElement ref : refsTo) {
                                PsiType cachedT = (PsiType)JavaResolveCache.this.myCalculatedTypes.get(ref);
                                if (cachedT == null || cachedT.isValid()) continue;
                                LOG.error("During invalidation of " + element + " (" + element.getClass() + ")" + " cached type " + cachedT + " of the ref " + ref + " (" + ref.getClass() + ")" + " became invalid and yet it is still cached");
                            }
                        }
                    }
                    return true;
                }
            });
        }
        DebugUtil.trackInvalidation(expr, "Expression invalidated", new Processor<PsiElement>(){

            @Override
            public boolean process(PsiElement element) {
                PsiType cachedRef;
                PsiType cached = (PsiType)JavaResolveCache.this.myCalculatedTypes.get(element);
                if (cached != null) {
                    LOG.error(element + " is invalid and yet it is still cached: " + cached);
                }
                if ((cachedRef = (PsiType)JavaResolveCache.this.myCachedReferencesInPsiTypes.get(element)) != null) {
                    LOG.error(element + " is invalid and yet it is still cached (inside PsiType): " + cachedRef);
                }
                return true;
            }
        });
    }

    @Nullable
    public Object computeConstantValueWithCaching(@NotNull PsiVariable variable, @NotNull ConstValueComputer computer, Set<PsiVariable> visitedVars) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveCache.computeConstantValueWithCaching must not be null");
        }
        if (computer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/JavaResolveCache.computeConstantValueWithCaching must not be null");
        }
        boolean physical = variable.isPhysical();
        Map<PsiVariable, Object> map = physical ? this.myVarToConstValueMapPhysical : this.myVarToConstValueMapNonPhysical;
        Object cached = map.get(variable);
        if (cached == NULL) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        Object result = computer.execute(variable, visitedVars);
        map.put(variable, result != null ? result : NULL);
        return result;
    }

    public static interface ConstValueComputer {
        public Object execute(PsiVariable var1, Set<PsiVariable> var2);
    }
}

