/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiJavaFileBaseImpl");
    @NonNls
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.create("LANGUAGE_LEVEL", new NotNullFunction<PsiJavaFileBaseImpl, LanguageLevel>(){

        @Override
        @NotNull
        public LanguageLevel fun(PsiJavaFileBaseImpl file) {
            LanguageLevel languageLevel = file.getLanguageLevelInner();
            if (languageLevel == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl$1.fun must not return null");
            }
            return languageLevel;
        }
    });

    protected PsiJavaFileBaseImpl(IElementType elementType, IElementType contentElementType, FileViewProvider viewProvider) {
        super(elementType, contentElementType, viewProvider);
        this.myResolveCache = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new MyCacheBuilder(this), false);
    }

    @Override
    protected PsiJavaFileBaseImpl clone() {
        PsiJavaFileBaseImpl clone = (PsiJavaFileBaseImpl)super.clone();
        clone.clearCaches();
        return clone;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray;
        StubElement stub = this.getStub();
        if (stub != null) {
            psiClassArray = (PsiClass[])stub.getChildrenByType(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
            if (psiClassArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getClasses must not return null");
            return psiClassArray;
        }
        psiClassArray = (PsiClass[])this.calcTreeElement().getChildrenAsPsiElements(Constants.CLASS_BIT_SET, Constants.PSI_CLASS_ARRAY_CONSTRUCTOR);
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getClasses must not return null");
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.PACKAGE_STATEMENT);
        return node != null ? (PsiPackageStatement)node.getPsi() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getPackageName() {
        String string;
        PsiJavaFileStub stub = (PsiJavaFileStub)this.getStub();
        if (stub != null) {
            String string2 = stub.getPackageName();
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getPackageName must not return null");
        }
        PsiPackageStatement statement = this.getPackageStatement();
        if (statement == null) {
            return "";
        }
        String string3 = statement.getPackageName();
        string = string3;
        if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getPackageName must not return null");
        return string;
    }

    @Override
    public void setPackageName(String packageName) throws IncorrectOperationException {
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
        if (packageStatement != null) {
            if (packageName.length() > 0) {
                PsiJavaCodeReferenceElement reference = packageStatement.getPackageReference();
                reference.replace(factory.createReferenceFromText(packageName, packageStatement));
            } else {
                packageStatement.delete();
            }
        } else if (packageName.length() > 0) {
            this.addBefore(factory.createPackageStatement(packageName), this.getFirstChild());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiImportList getImportList() {
        PsiImportList psiImportList;
        StubElement stub = this.getStub();
        if (stub != null) {
            PsiImportList[] nodes = (PsiImportList[])stub.getChildrenByType(JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY);
            assert (nodes.length == 1) : this.getFileType() + ", " + this.getName();
            psiImportList = nodes[0];
            if (psiImportList == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getImportList must not return null");
            return psiImportList;
        }
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.IMPORT_LIST);
        assert (node != null) : this.getFileType() + ", " + this.getName();
        psiImportList = (PsiImportList)SourceTreeToPsiMap.treeToPsiNotNull(node);
        if (psiImportList != null) return psiImportList;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getImportList must not return null");
    }

    @Override
    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements;
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        PsiImportList importList = this.getImportList();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            array.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array.add(resolved);
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getOnDemandImports must not return null");
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements;
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        PsiImportList importList = this.getImportList();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || !((ref = statement.resolve()) instanceof PsiClass)) continue;
            array.add((PsiClass)ref);
        }
        PsiClass[] psiClassArray = array.toArray(new PsiClass[array.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getSingleClassImports must not return null");
        }
        return psiClassArray;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || (ref = statement.resolve()) == null || !this.getManager().areElementsEquivalent(ref, aClass)) continue;
            return statement.getImportReference();
        }
        return null;
    }

    @Override
    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (IMPLICIT_IMPORTS == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getImplicitlyImportedPackages must not return null");
        }
        return IMPLICIT_IMPORTS;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = PsiImplUtil.namesToPackageReferences(this.myManager, IMPLICIT_IMPORTS);
        if (psiJavaCodeReferenceElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getImplicitlyImportedPackageReferences must not return null");
        }
        return psiJavaCodeReferenceElementArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiJavaFileBaseImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiJavaFileBaseImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiJavaFileBaseImpl.processDeclarations must not be null");
        }
        if (processor instanceof ClassResolverProcessor && this.isPhysical() && (this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue())) {
            ClassResolverProcessor hint = (ClassResolverProcessor)processor;
            String name = hint.getName(state);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> cache = this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(processor, state);
            return name != null ? cache.processForKey(name, cacheProcessor) : cache.processAllValues(cacheProcessor);
        }
        return this.processDeclarationsNoGuess(processor, state, lastParent, place);
    }

    private boolean processDeclarationsNoGuess(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        PsiImportStaticStatement[] importStaticStatements;
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        String name = nameHint != null ? nameHint.getName(state) : null;
        PsiImportList importList = this.getImportList();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiImportStatement[] importStatements;
            PsiClass[] classes;
            for (PsiClass aClass : classes = this.getClasses()) {
                if (processor.execute(aClass, state)) continue;
                return false;
            }
            PsiImportStatement[] arr$ = importStatements = importList.getImportStatements();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                PsiElement psiElement;
                String string;
                PsiImportStatement statement = arr$[i$];
                if (statement.isOnDemand() || name != null && ((string = statement.getQualifiedName()) == null || !string.endsWith(name)) || !((psiElement = statement.resolve()) instanceof PsiClass)) continue;
                processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, statement);
                if (processor.execute(psiElement, state)) continue;
                return false;
            }
            processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiPackage aPackage = JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.getPackageName());
            if (aPackage != null && !aPackage.processDeclarations(processor, state, null, place)) {
                return false;
            }
            for (PsiImportStatementBase psiImportStatementBase : importStatements) {
                PsiElement resolved2;
                if (!psiImportStatementBase.isOnDemand() || (resolved2 = psiImportStatementBase.resolve()) == null) continue;
                processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiImportStatementBase);
                PsiJavaFileBaseImpl.processOnDemandTarget(resolved2, processor, state, place);
            }
        }
        if ((importStaticStatements = importList.getImportStaticStatements()).length > 0) {
            StaticImportFilteringProcessor staticImportProcessor = new StaticImportFilteringProcessor(processor);
            boolean forCompletion = Boolean.TRUE == processor.getHint(JavaCompletionHints.JAVA_COMPLETION);
            for (PsiImportStaticStatement psiImportStaticStatement : importStaticStatements) {
                JavaResolveResult[] results;
                PsiJavaCodeReferenceElement reference;
                if (psiImportStaticStatement.isOnDemand() || forCompletion || (reference = psiImportStaticStatement.getImportReference()) == null || (results = reference.multiResolve(false)).length <= 0) continue;
                staticImportProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiImportStaticStatement);
                for (JavaResolveResult result : results) {
                    if (staticImportProcessor.execute(result.getElement(), state)) continue;
                    return false;
                }
            }
            for (PsiImportStatementBase psiImportStatementBase : importStaticStatements) {
                PsiClass targetElement;
                if (!psiImportStatementBase.isOnDemand() || (targetElement = psiImportStatementBase.resolveTargetClass()) == null) continue;
                staticImportProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiImportStatementBase);
                if (targetElement.processDeclarations(staticImportProcessor, state, lastParent, place)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiJavaCodeReferenceElement[] implicitlyImported;
            processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            for (PsiJavaCodeReferenceElement aImplicitlyImported : implicitlyImported = this.getImplicitlyImportedPackageReferences()) {
                PsiElement psiElement = aImplicitlyImported.resolve();
                if (psiElement == null || PsiJavaFileBaseImpl.processOnDemandTarget(psiElement, processor, state, place)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processOnDemandTarget(PsiElement target, PsiScopeProcessor processor, ResolveState substitutor, PsiElement place) {
        if (target instanceof PsiPackage) {
            if (!target.processDeclarations(processor, substitutor, null, place)) {
                return false;
            }
        } else if (target instanceof PsiClass) {
            PsiClass[] inners;
            for (PsiClass inner : inners = ((PsiClass)target).getInnerClasses()) {
                if (processor.execute(inner, substitutor)) continue;
                return false;
            }
        } else {
            LOG.assertTrue(false);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiJavaFileBaseImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile(this);
        } else {
            visitor.visitFile(this);
        }
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getLanguage must not return null");
        }
        return javaLanguage;
    }

    @Override
    public boolean importClass(PsiClass aClass) {
        return JavaCodeStyleManager.getInstance(this.getProject()).addImport(this, aClass);
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = LANGUAGE_LEVEL_KEY.getValue(this);
        if (languageLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaFileBaseImpl.getLanguageLevel must not return null");
        }
        return languageLevel;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.putUserData(LANGUAGE_LEVEL_KEY, null);
    }

    private LanguageLevel getLanguageLevelInner() {
        LanguageLevel level;
        if (this.myOriginalFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
        }
        LanguageLevel forcedLanguageLevel = this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            return forcedLanguageLevel;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = this.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        }
        Project project = this.getProject();
        if (virtualFile == null) {
            PsiFile originalFile = this.getOriginalFile();
            if (originalFile instanceof PsiJavaFile && originalFile != this) {
                return ((PsiJavaFile)originalFile).getLanguageLevel();
            }
            return LanguageLevelProjectExtension.getInstance(project).getLanguageLevel();
        }
        VirtualFile folder = virtualFile.getParent();
        if (folder != null && (level = folder.getUserData(LanguageLevel.KEY)) != null) {
            return level;
        }
        LanguageLevel classesLanguageLevel = JavaPsiImplementationHelper.getInstance(project).getClassesLanguageLevel(virtualFile);
        if (classesLanguageLevel != null) {
            return classesLanguageLevel;
        }
        return LanguageLevelProjectExtension.getInstance(project).getLanguageLevel();
    }

    private static class MyResolveCacheProcessor
    implements Processor<SymbolCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        public MyResolveCacheProcessor(PsiScopeProcessor processor, ResolveState state) {
            this.myProcessor = processor;
            this.myState = state;
        }

        @Override
        public boolean process(SymbolCollectingProcessor.ResultWithContext result) {
            this.myProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, result.getFileContext());
            return this.myProcessor.execute(result.getElement(), this.myState);
        }
    }

    private static class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> {
        private final PsiJavaFileBaseImpl myFile;

        public MyCacheBuilder(PsiJavaFileBaseImpl file) {
            this.myFile = file;
        }

        @Override
        public CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> compute() {
            SymbolCollectingProcessor p = new SymbolCollectingProcessor();
            this.myFile.processDeclarationsNoGuess(p, ResolveState.initial(), this.myFile, this.myFile);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> results = p.getResults();
            return CachedValueProvider.Result.create(results, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        }
    }

    private static class StaticImportFilteringProcessor
    implements PsiScopeProcessor {
        private final PsiScopeProcessor myDelegate;
        private boolean myIsProcessingOnDemand;
        private final Collection<String> myHiddenNames = new HashSet<String>();
        private final Collection<PsiElement> myCollectedElements = new HashSet<PsiElement>();

        public StaticImportFilteringProcessor(PsiScopeProcessor delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public <T> T getHint(Key<T> hintKey) {
            return this.myDelegate.getHint(hintKey);
        }

        @Override
        public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
            if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)associated;
                this.myIsProcessingOnDemand = importStaticStatement.isOnDemand();
                if (!this.myIsProcessingOnDemand) {
                    this.myHiddenNames.add(importStaticStatement.getReferenceName());
                }
            }
            this.myDelegate.handleEvent(event, associated);
        }

        @Override
        public boolean execute(PsiElement element, ResolveState state) {
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                String name;
                if (element instanceof PsiNamedElement && this.myIsProcessingOnDemand && this.myHiddenNames.contains(name = ((PsiNamedElement)element).getName())) {
                    return true;
                }
                if (this.myCollectedElements.add(element)) {
                    return this.myDelegate.execute(element, state);
                }
            }
            return true;
        }
    }
}

