/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ConstructorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.classes.AnnotationTypeFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ICodeFragmentElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.SourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaCodeReferenceElementImpl
extends CompositePsiElement
implements PsiJavaCodeReferenceElement,
SourceJavaCodeReference {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl");
    private volatile String myCachedQName = null;
    private volatile String myCachedTextSkipWhiteSpaceAndComments;
    private int myKindWhenDummy = 1;
    public static final int CLASS_NAME_KIND = 1;
    public static final int PACKAGE_NAME_KIND = 2;
    public static final int CLASS_OR_PACKAGE_NAME_KIND = 3;
    public static final int CLASS_FQ_NAME_KIND = 4;
    public static final int CLASS_FQ_OR_PACKAGE_NAME_KIND = 5;
    public static final int CLASS_IN_QUALIFIED_NEW_KIND = 6;
    private final int myHC = CompositePsiElement.ourHC++;

    public final int hashCode() {
        return this.myHC;
    }

    public PsiJavaCodeReferenceElementImpl() {
        super(JavaElementType.JAVA_CODE_REFERENCE);
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.getReferenceNameNode();
        return refName != null ? refName.getStartOffset() : super.getTextOffset();
    }

    public void setKindWhenDummy(int kind) {
        LOG.assertTrue(PsiJavaCodeReferenceElementImpl.isDummy(this.getTreeParent().getElementType()));
        this.myKindWhenDummy = kind;
    }

    private static boolean isDummy(IElementType type) {
        return type == TokenType.DUMMY_HOLDER || type == JavaElementType.DUMMY_ELEMENT;
    }

    public int getKind() {
        CompositeElement parent;
        IElementType i = this.getTreeParent().getElementType();
        if (PsiJavaCodeReferenceElementImpl.isDummy(i)) {
            return this.myKindWhenDummy;
        }
        if (i == JavaElementType.TYPE) {
            return this.getTreeParent().getTreeParent().getPsi() instanceof PsiTypeCodeFragment ? 3 : 1;
        }
        if (i == JavaElementType.EXTENDS_LIST || i == JavaElementType.IMPLEMENTS_LIST || i == JavaElementType.EXTENDS_BOUND_LIST || i == JavaElementType.THROWS_LIST || i == JavaElementType.THIS_EXPRESSION || i == JavaElementType.SUPER_EXPRESSION || i == JavaDocElementType.DOC_METHOD_OR_FIELD_REF || i == JavaDocTokenType.DOC_TAG_VALUE_TOKEN || i == JavaElementType.REFERENCE_PARAMETER_LIST || i == JavaElementType.ANNOTATION) {
            if (this.isQualified()) {
                return 3;
            }
            return 1;
        }
        if (i == JavaElementType.NEW_EXPRESSION) {
            ASTNode qualifier = this.getTreeParent().findChildByRole(54);
            return qualifier != null ? 6 : 1;
        }
        if (i == JavaElementType.ANONYMOUS_CLASS) {
            if (this.getTreeParent().getChildRole(this) == 78) {
                LOG.assertTrue(this.getTreeParent().getTreeParent().getElementType() == JavaElementType.NEW_EXPRESSION);
                ASTNode qualifier = this.getTreeParent().getTreeParent().findChildByRole(54);
                return qualifier != null ? 6 : 1;
            }
            return 3;
        }
        if (i == JavaElementType.PACKAGE_STATEMENT) {
            return 2;
        }
        if (i == JavaElementType.IMPORT_STATEMENT) {
            boolean isOnDemand = ((PsiImportStatement)SourceTreeToPsiMap.treeElementToPsi(this.getTreeParent())).isOnDemand();
            return isOnDemand ? 5 : 4;
        }
        if (i == JavaElementType.IMPORT_STATIC_STATEMENT) {
            return 5;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            int parentKind = ((PsiJavaCodeReferenceElementImpl)this.getTreeParent()).getKind();
            switch (parentKind) {
                case 1: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
            }
            LOG.assertTrue(false);
            return -1;
        }
        if (i == JavaElementType.CLASS || i == JavaElementType.PARAMETER_LIST || i == TokenType.ERROR_ELEMENT) {
            return 3;
        }
        if (i == JavaElementType.IMPORT_STATIC_REFERENCE) {
            return 5;
        }
        if (i == JavaDocElementType.DOC_TAG || i == JavaDocElementType.DOC_INLINE_TAG || i == JavaDocElementType.DOC_REFERENCE_HOLDER || i == JavaDocElementType.DOC_TYPE_HOLDER) {
            return 3;
        }
        if (PsiJavaCodeReferenceElementImpl.isCodeFragmentType(i)) {
            PsiJavaCodeReferenceCodeFragment fragment = (PsiJavaCodeReferenceCodeFragment)this.getTreeParent().getPsi();
            return fragment.isClassesAccepted() ? 5 : 2;
        }
        String message = "Unknown parent for java code reference: '" + parent + "'; Type: " + i + ";\n";
        for (parent = this.getTreeParent(); parent != null && parent.getPsi() instanceof PsiExpression; parent = parent.getTreeParent()) {
            message = message + " Parent: '" + parent + "'; \n";
        }
        if (parent != null) {
            message = message + DebugUtil.treeToString(parent, false);
        }
        LOG.error(message);
        return 1;
    }

    private static boolean isCodeFragmentType(IElementType type) {
        return type == TokenType.CODE_FRAGMENT || type instanceof ICodeFragmentElementType;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.deleteChildInternal must not be null");
        }
        if (this.getChildRole(child) == 54) {
            ASTNode dot = this.findChildByRole(55);
            this.deleteChildRange(child.getPsi(), dot.getPsi());
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    public final ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 53: {
                if (this.getLastChildNode().getElementType() == JavaTokenType.IDENTIFIER) {
                    return this.getLastChildNode();
                }
                if (this.getLastChildNode().getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST) {
                    ASTNode current;
                    for (current = this.getLastChildNode().getTreePrev(); current != null && (current.getPsi() instanceof PsiWhiteSpace || current.getPsi() instanceof PsiComment); current = current.getTreePrev()) {
                    }
                    if (current != null && current.getElementType() == JavaTokenType.IDENTIFIER) {
                        return current;
                    }
                }
                return null;
            }
            case 246: {
                if (this.getLastChildNode().getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST) {
                    return this.getLastChildNode();
                }
                return null;
            }
            case 54: {
                if (this.getFirstChildNode().getElementType() == JavaElementType.JAVA_CODE_REFERENCE) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 55: 
        }
        return this.findChildByType(JavaTokenType.DOT);
    }

    @Override
    public final int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getCanonicalText() {
        String string;
        switch (this.getKind()) {
            case 1: 
            case 3: 
            case 6: {
                PsiElement target = this.resolve();
                if (target instanceof PsiClass) {
                    PsiType[] types;
                    PsiClass aClass = (PsiClass)target;
                    String name = aClass.getQualifiedName();
                    if (name == null) {
                        name = aClass.getName();
                    }
                    if ((types = this.getTypeParameters()).length == 0) {
                        String string2 = name;
                        string = string2;
                        if (string2 != null) return string;
                        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.getCanonicalText must not return null");
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append(name);
                    buf.append('<');
                    int i = 0;
                    while (true) {
                        if (i >= types.length) {
                            buf.append('>');
                            String string3 = buf.toString();
                            string = string3;
                            if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.getCanonicalText must not return null");
                            return string;
                        }
                        if (i > 0) {
                            buf.append(',');
                        }
                        buf.append(types[i].getCanonicalText());
                        ++i;
                    }
                }
                if (target instanceof PsiPackage) {
                    String string4 = ((PsiPackage)target).getQualifiedName();
                    string = string4;
                    if (string4 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.getCanonicalText must not return null");
                    return string;
                }
                LOG.assertTrue(target == null, target);
                String string5 = this.getTextSkipWhiteSpaceAndComments();
                string = string5;
                if (string5 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.getCanonicalText must not return null");
                return string;
            }
            case 2: 
            case 4: 
            case 5: {
                String string6 = this.getTextSkipWhiteSpaceAndComments();
                string = string6;
                if (string6 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.getCanonicalText must not return null");
                return string;
            }
        }
        LOG.assertTrue(false);
        string = null;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.getCanonicalText must not return null");
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    public final PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult;
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            javaResolveResult = results[0];
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.advancedResolve must not return null");
            return javaResolveResult;
        }
        javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult != null) return javaResolveResult;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.advancedResolve must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        PsiManager manager = this.getManager();
        if (manager == null) {
            LOG.error("getManager() == null!");
            javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            if (JavaResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.multiResolve must not return null");
            return javaResolveResultArray;
        }
        ResolveCache resolveCache = ResolveCache.getInstance(this.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, OurGenericsResolver.INSTANCE, true, incompleteCode);
        javaResolveResultArray = results.length == 0 ? JavaResolveResult.EMPTY_ARRAY : (JavaResolveResult[])results;
        if (javaResolveResultArray != null) return javaResolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.multiResolve must not return null");
    }

    private PsiSubstitutor updateSubstitutor(PsiSubstitutor subst, PsiClass psiClass) {
        PsiType[] parameters = this.getTypeParameters();
        if (psiClass != null) {
            subst = subst.putAll(psiClass, parameters);
        }
        return subst;
    }

    private JavaResolveResult[] resolve(int kind) {
        switch (kind) {
            case 4: {
                String textSkipWhiteSpaceAndComments = this.getTextSkipWhiteSpaceAndComments();
                if (textSkipWhiteSpaceAndComments == null || textSkipWhiteSpaceAndComments.length() == 0) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiClass aClass = JavaPsiFacade.getInstance(this.getProject()).findClass(textSkipWhiteSpaceAndComments, this.getResolveScope());
                if (aClass == null) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                return new JavaResolveResult[]{new CandidateInfo((PsiElement)aClass, this.updateSubstitutor(PsiSubstitutor.EMPTY, aClass), this, false)};
            }
            case 6: {
                PsiElement parent = this.getParent();
                if (parent instanceof JavaDummyHolder) {
                    parent = parent.getContext();
                }
                if (parent instanceof PsiAnonymousClass) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof PsiNewExpression)) {
                    if (parent instanceof PsiJavaCodeReferenceElement) {
                        return JavaResolveResult.EMPTY_ARRAY;
                    }
                    LOG.error("Invalid java reference!");
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiExpression qualifier = ((PsiNewExpression)parent).getQualifier();
                LOG.assertTrue(qualifier != null);
                PsiType qualifierType = qualifier.getType();
                if (qualifierType == null) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                if (!(qualifierType instanceof PsiClassType)) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiClassType.ClassResolveResult result = PsiUtil.resolveGenericsClassInType(qualifierType);
                if (result.getElement() == null) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiElement classNameElement = this.getReferenceNameElement();
                if (!(classNameElement instanceof PsiIdentifier)) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                String className = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className, this);
                result.getElement().processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result.getSubstitutor()), this, this);
                return processor.getResult();
            }
            case 1: {
                PsiElement classNameElement = this.getReferenceNameElement();
                if (!(classNameElement instanceof PsiIdentifier)) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                String className = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className, this);
                PsiScopesUtil.resolveAndWalk(processor, this, null);
                return processor.getResult();
            }
            case 2: {
                String packageName = this.getTextSkipWhiteSpaceAndComments();
                PsiManager manager = this.getManager();
                PsiPackage aPackage = JavaPsiFacade.getInstance(manager.getProject()).findPackage(packageName);
                if (aPackage == null || !aPackage.isValid()) {
                    return JavaPsiFacade.getInstance(manager.getProject()).isPartOfPackagePrefix(packageName) ? CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE : JavaResolveResult.EMPTY_ARRAY;
                }
                return new JavaResolveResult[]{new CandidateInfo(aPackage, PsiSubstitutor.EMPTY)};
            }
            case 5: {
                JavaResolveResult[] result = this.resolve(4);
                if (result.length == 0) {
                    return this.resolve(2);
                }
                return result;
            }
            case 3: {
                JavaResolveResult[] packageResolveResult;
                JavaResolveResult[] classResolveResult = this.resolve(1);
                if (classResolveResult.length == 0 && (packageResolveResult = this.resolve(2)).length > 0) {
                    return packageResolveResult;
                }
                return classResolveResult;
            }
        }
        LOG.assertTrue(false);
        return JavaResolveResult.EMPTY_ARRAY;
    }

    @Override
    public final PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.getReferenceNameElement();
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.bindToElement must not be null");
        }
        CheckUtil.checkWritable(this);
        if (this.isReferenceTo(element)) {
            return this;
        }
        switch (this.getKind()) {
            case 1: 
            case 4: {
                if (!(element instanceof PsiClass)) {
                    throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
                }
                return this.bindToClass((PsiClass)element);
            }
            case 2: {
                if (!(element instanceof PsiPackage)) {
                    throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
                }
                return this.bindToPackage((PsiPackage)element);
            }
            case 3: 
            case 5: {
                if (element instanceof PsiClass) {
                    return this.bindToClass((PsiClass)element);
                }
                if (element instanceof PsiPackage) {
                    return this.bindToPackage((PsiPackage)element);
                }
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
            }
            case 6: {
                if (element instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)element;
                    String name = aClass.getName();
                    if (name == null) {
                        throw new IncorrectOperationException(aClass.toString());
                    }
                    PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
                    PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(name, this.getParent());
                    this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
                    return ref;
                }
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    private static IncorrectOperationException cannotBindError(PsiElement element) {
        return new IncorrectOperationException("Cannot bind to " + element);
    }

    private PsiElement bindToClass(PsiClass aClass) throws IncorrectOperationException {
        PsiReferenceParameterList parameterList;
        String qName = aClass.getQualifiedName();
        boolean preserveQualification = JavaCodeStyleSettingsFacade.getInstance(this.getProject()).useFQClassNames() && this.isFullyQualified();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(this.getProject());
        if (qName == null) {
            qName = aClass.getName();
            PsiClass psiClass = facade.getResolveHelper().resolveReferencedClass(qName, this);
            if (!this.getManager().areElementsEquivalent(psiClass, aClass)) {
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(aClass);
            }
        } else if (facade.findClass(qName, this.getResolveScope()) == null && !preserveQualification) {
            return this;
        }
        String text = (parameterList = this.getParameterList()) == null ? qName : qName + parameterList.getText();
        PsiJavaCodeReferenceElement ref = facade.getParserFacade().createReferenceFromText(text, this.getParent());
        this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
        if (!preserveQualification) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(aClass.getProject());
            ref = (PsiJavaCodeReferenceElement)codeStyleManager.shortenClassReferences(ref, 8192);
        }
        return ref;
    }

    private boolean isFullyQualified() {
        switch (this.getKind()) {
            case 3: {
                if (this.resolve() instanceof PsiPackage) {
                    return true;
                }
            }
            case 1: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
            default: {
                LOG.assertTrue(false);
                return true;
            }
        }
        ASTNode qualifier = this.findChildByRole(54);
        if (qualifier == null) {
            return false;
        }
        LOG.assertTrue(qualifier.getElementType() == JavaElementType.JAVA_CODE_REFERENCE);
        PsiElement refElement = ((PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(qualifier)).resolve();
        if (refElement instanceof PsiPackage) {
            return true;
        }
        return ((PsiJavaCodeReferenceElementImpl)SourceTreeToPsiMap.treeElementToPsi(qualifier)).isFullyQualified();
    }

    private PsiElement bindToPackage(PsiPackage aPackage) throws IncorrectOperationException {
        String qName = aPackage.getQualifiedName();
        if (qName.length() == 0) {
            throw new IncorrectOperationException("Cannot bind to default package: " + aPackage);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(qName, this.getParent());
        this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
        return ref;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        switch (this.getKind()) {
            case 1: 
            case 6: {
                if (element instanceof PsiClass) break;
                return false;
            }
            case 4: {
                if (!(element instanceof PsiClass)) {
                    return false;
                }
                String qName = ((PsiClass)element).getQualifiedName();
                return qName != null && qName.equals(this.getCanonicalText());
            }
            case 2: {
                if (!(element instanceof PsiPackage)) {
                    return false;
                }
                String qName = ((PsiPackage)element).getQualifiedName();
                return qName.equals(this.getCanonicalText());
            }
            case 3: {
                if (element instanceof PsiPackage) {
                    String qName = ((PsiPackage)element).getQualifiedName();
                    return qName.equals(this.getCanonicalText());
                }
                if (element instanceof PsiClass) {
                    PsiIdentifier nameIdentifier = ((PsiClass)element).getNameIdentifier();
                    if (nameIdentifier == null) {
                        return false;
                    }
                    PsiElement nameElement = this.getReferenceNameElement();
                    return nameElement != null && nameElement.textMatches(nameIdentifier) && element.getManager().areElementsEquivalent(this.resolve(), element);
                }
                return false;
            }
            case 5: {
                if (element instanceof PsiClass) {
                    String qName = ((PsiClass)element).getQualifiedName();
                    return qName != null && qName.equals(this.getCanonicalText());
                }
                if (element instanceof PsiPackage) {
                    String qName = ((PsiPackage)element).getQualifiedName();
                    return qName.equals(this.getCanonicalText());
                }
                return false;
            }
            default: {
                LOG.assertTrue(false);
                return true;
            }
        }
        ASTNode referenceNameElement = this.getReferenceNameNode();
        if (referenceNameElement == null || referenceNameElement.getElementType() != JavaTokenType.IDENTIFIER) {
            return false;
        }
        String name = ((PsiClass)element).getName();
        return name != null && referenceNameElement.getText().equals(name) && element.getManager().areElementsEquivalent(this.resolve(), element);
    }

    private String getTextSkipWhiteSpaceAndComments() {
        String whiteSpaceAndComments = this.myCachedTextSkipWhiteSpaceAndComments;
        if (whiteSpaceAndComments == null) {
            this.myCachedTextSkipWhiteSpaceAndComments = whiteSpaceAndComments = SourceUtil.getTextSkipWhiteSpaceAndComments(this);
        }
        return whiteSpaceAndComments;
    }

    @Override
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName(this.getTextSkipWhiteSpaceAndComments(), false);
        }
        return cachedQName;
    }

    @Override
    public void fullyQualify(PsiClass targetClass) {
        int kind = this.getKind();
        if (kind != 1 && kind != 3 && kind != 6) {
            LOG.error("Wrong kind " + kind);
            return;
        }
        JavaSourceUtil.fullyQualifyReference(this, targetClass);
    }

    @Override
    public boolean isQualified() {
        return this.getChildRole(this.getFirstChildNode()) != 53;
    }

    @Override
    public PsiElement getQualifier() {
        return SourceTreeToPsiMap.treeElementToPsi(this.findChildByRole(54));
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedQName = null;
        this.myCachedTextSkipWhiteSpaceAndComments = null;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        ElementFilter filter;
        switch (this.getKind()) {
            case 3: {
                filter = new OrFilter();
                ((OrFilter)filter).addFilter(ElementClassFilter.CLASS);
                ((OrFilter)filter).addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 1: {
                filter = ElementClassFilter.CLASS;
                break;
            }
            case 2: {
                filter = ElementClassFilter.PACKAGE_FILTER;
                break;
            }
            case 4: 
            case 5: {
                filter = new OrFilter();
                ((OrFilter)filter).addFilter(ElementClassFilter.PACKAGE_FILTER);
                if (!this.isQualified()) break;
                ((OrFilter)filter).addFilter(ElementClassFilter.CLASS);
                break;
            }
            case 6: {
                filter = ElementClassFilter.CLASS;
                break;
            }
            default: {
                throw new RuntimeException("Unknown reference type");
            }
        }
        Object[] objectArray = PsiImplUtil.getReferenceVariantsByFilter(this, filter);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.getVariants must not return null");
        }
        return objectArray;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void processVariants(PsiScopeProcessor processor) {
        OrFilter filter = new OrFilter();
        if (this.isInCode()) {
            filter.addFilter(new AndFilter((ElementFilter)ElementClassFilter.METHOD, (ElementFilter)new NotFilter(new ConstructorFilter())));
            filter.addFilter(ElementClassFilter.VARIABLE);
        }
        switch (this.getKind()) {
            case 3: {
                this.addClassFilter(filter);
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 1: {
                this.addClassFilter(filter);
                if (!this.isQualified()) break;
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 2: {
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 4: 
            case 5: {
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                if (!this.isQualified()) break;
                filter.addFilter(ElementClassFilter.CLASS);
                break;
            }
            case 6: {
                PsiNewExpression newExpr;
                PsiType type;
                PsiClass aClass;
                PsiElement parent = this.getParent();
                if (parent instanceof PsiNewExpression && (aClass = PsiUtil.resolveClassInType(type = (newExpr = (PsiNewExpression)parent).getQualifier().getType())) != null) {
                    aClass.processDeclarations(new FilterScopeProcessor((ElementFilter)new AndFilter((ElementFilter)ElementClassFilter.CLASS, (ElementFilter)new ModifierFilter("static", false)), processor), ResolveState.initial(), null, this);
                }
                return;
            }
            default: {
                throw new RuntimeException("Unknown reference type");
            }
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)filter, processor);
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    private boolean isInCode() {
        if (PsiJavaCodeReferenceElementImpl.isCodeFragmentType(this.getTreeParent().getElementType()) || this.getParent() instanceof PsiAnnotation) {
            return false;
        }
        if (this.isQualified()) {
            return true;
        }
        for (PsiElement superParent = this.getParent(); superParent != null; superParent = superParent.getParent()) {
            if (superParent instanceof PsiCodeBlock || superParent instanceof PsiLocalVariable) {
                return true;
            }
            if (!(superParent instanceof PsiClass)) continue;
            return false;
        }
        return false;
    }

    private void addClassFilter(OrFilter filter) {
        if (this.getParent() instanceof PsiAnnotation) {
            filter.addFilter(new AnnotationTypeFilter());
        } else {
            filter.addFilter(ElementClassFilter.CLASS);
        }
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return SourceTreeToPsiMap.treeElementToPsi(this.getReferenceNameNode());
    }

    @Nullable
    private ASTNode getReferenceNameNode() {
        return this.findChildByRole(53);
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return (PsiReferenceParameterList)this.findChildByRoleAsPsiElement(246);
    }

    @Override
    public String getQualifiedName() {
        switch (this.getKind()) {
            case 1: 
            case 3: 
            case 6: {
                PsiElement target = this.resolve();
                if (target instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)target;
                    String name = aClass.getQualifiedName();
                    if (name == null) {
                        name = aClass.getName();
                    }
                    return name;
                }
                if (target instanceof PsiPackage) {
                    return ((PsiPackage)target).getQualifiedName();
                }
                LOG.assertTrue(target == null);
                return this.getClassNameText();
            }
            case 2: 
            case 4: 
            case 5: {
                return this.getTextSkipWhiteSpaceAndComments();
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    @Override
    public String getReferenceName() {
        ASTNode childByRole = this.getReferenceNameNode();
        if (childByRole == null) {
            return null;
        }
        return childByRole.getText();
    }

    @Override
    public final TextRange getRangeInElement() {
        TreeElement nameChild = (TreeElement)this.getReferenceNameNode();
        if (nameChild == null) {
            return new TextRange(0, this.getTextLength());
        }
        int startOffset = nameChild.getStartOffsetInParent();
        return new TextRange(startOffset, startOffset + nameChild.getTextLength());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiType[] psiTypeArray;
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList == null) {
            psiTypeArray = PsiType.EMPTY_ARRAY;
            if (PsiType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.getTypeParameters must not return null");
            return psiTypeArray;
        }
        psiTypeArray = parameterList.getTypeArguments();
        if (psiTypeArray != null) return psiTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.getTypeParameters must not return null");
    }

    @Override
    public final PsiElement getElement() {
        return this;
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public final String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantResolver<PsiJavaReference> {
        private static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        public static JavaResolveResult[] _resolve(PsiJavaReference ref, boolean incompleteCode) {
            PsiJavaCodeReferenceElementImpl referenceElement = (PsiJavaCodeReferenceElementImpl)ref;
            int kind = referenceElement.getKind();
            JavaResolveResult[] result = referenceElement.resolve(kind);
            if (incompleteCode && result.length == 0 && kind != 4 && kind != 5) {
                VariableResolverProcessor processor = new VariableResolverProcessor(referenceElement);
                PsiScopesUtil.resolveAndWalk(processor, referenceElement, null, incompleteCode);
                result = processor.getResult();
                if (result.length == 0 && kind == 1) {
                    return referenceElement.resolve(2);
                }
            }
            return result;
        }

        @Override
        public JavaResolveResult[] resolve(PsiJavaReference ref, boolean incompleteCode) {
            JavaResolveResult[] result = OurGenericsResolver._resolve(ref, incompleteCode);
            if (result.length > 0 && result[0].getElement() instanceof PsiClass) {
                PsiType[] parameters = ((PsiJavaCodeReferenceElement)ref).getTypeParameters();
                JavaResolveResult[] newResult = new JavaResolveResult[result.length];
                for (int i = 0; i < result.length; ++i) {
                    CandidateInfo resolveResult = (CandidateInfo)result[i];
                    PsiClass aClass = (PsiClass)resolveResult.getElement();
                    assert (aClass != null);
                    newResult[i] = !aClass.hasTypeParameters() ? resolveResult : new CandidateInfo(resolveResult, resolveResult.getSubstitutor().putAll(aClass, parameters));
                }
                return newResult;
            }
            return result;
        }
    }
}

