/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.StringRef;

public class PsiClassReferenceListStubImpl
extends StubBase<PsiReferenceList>
implements PsiClassReferenceListStub {
    private final PsiReferenceList.Role myRole;
    private final StringRef[] myNames;
    private PsiClassType[] myTypes;

    public PsiClassReferenceListStubImpl(JavaClassReferenceListElementType type, StubElement parent, String[] names, PsiReferenceList.Role role) {
        super(parent, type);
        this.myNames = StringRef.createArray(names.length);
        for (int i = 0; i < names.length; ++i) {
            this.myNames[i] = StringRef.fromString(names[i]);
        }
        this.myRole = role;
    }

    public PsiClassReferenceListStubImpl(JavaClassReferenceListElementType type, StubElement parent, StringRef[] names, PsiReferenceList.Role role) {
        super(parent, type);
        this.myNames = names;
        this.myRole = role;
    }

    @Override
    public PsiClassType[] getReferencedTypes() {
        if (this.myTypes != null) {
            return this.myTypes;
        }
        if (this.myNames.length == 0) {
            this.myTypes = PsiClassType.EMPTY_ARRAY;
            return this.myTypes;
        }
        PsiClassType[] types = new PsiClassType[this.myNames.length];
        boolean compiled = ((JavaClassReferenceListElementType)this.getStubType()).isCompiled(this);
        if (compiled) {
            for (int i = 0; i < types.length; ++i) {
                types[i] = new PsiClassReferenceType(new ClsJavaCodeReferenceElementImpl((PsiElement)this.getPsi(), StringRef.toString(this.myNames[i])), null);
            }
        } else {
            PsiElementFactory factory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
            int nullCount = 0;
            PsiReferenceList psi = (PsiReferenceList)this.getPsi();
            for (int i = 0; i < types.length; ++i) {
                PsiElement context = psi;
                if (this.getParentStub() instanceof PsiClassStub) {
                    context = ((PsiClassImpl)this.getParentStub().getPsi()).calcBasesResolveContext(PsiNameHelper.getShortClassName(StringRef.toString(this.myNames[i])), psi);
                }
                try {
                    PsiJavaCodeReferenceElement ref = factory.createReferenceFromText(StringRef.toString(this.myNames[i]), context);
                    ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(1);
                    types[i] = factory.createType(ref);
                    continue;
                }
                catch (IncorrectOperationException e) {
                    types[i] = null;
                    ++nullCount;
                }
            }
            if (nullCount > 0) {
                PsiClassType[] newTypes = new PsiClassType[types.length - nullCount];
                int cnt = 0;
                for (PsiClassType type : types) {
                    if (type == null) continue;
                    newTypes[cnt++] = type;
                }
                types = newTypes;
            }
        }
        this.myTypes = types;
        return types;
    }

    @Override
    public String[] getReferencedNames() {
        String[] names = ArrayUtil.newStringArray(this.myNames.length);
        for (int i = 0; i < names.length; ++i) {
            names[i] = StringRef.toString(this.myNames[i]);
        }
        return names;
    }

    @Override
    public PsiReferenceList.Role getRole() {
        return this.myRole;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiRefListStub[").append(this.myRole.name()).append(":");
        for (int i = 0; i < this.myNames.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.myNames[i]);
        }
        builder.append("]");
        return builder.toString();
    }
}

