/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PatchedSoftReference;

public class PsiAnnotationStubImpl
extends StubBase<PsiAnnotation>
implements PsiAnnotationStub {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl");
    private final String myText;
    private PatchedSoftReference<CompositeElement> myParsedFromRepository;

    public PsiAnnotationStubImpl(StubElement parent, String text) {
        super(parent, JavaStubElementTypes.ANNOTATION);
        this.myText = text;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public CompositeElement getTreeElement() {
        CompositeElement parsed;
        if (this.myParsedFromRepository != null && (parsed = (CompositeElement)this.myParsedFromRepository.get()) != null) {
            return parsed;
        }
        String text = this.getText();
        try {
            CompositeElement parsed2 = (CompositeElement)JavaPsiFacade.getInstance(this.getProject()).getParserFacade().createAnnotationFromText(text, (PsiElement)this.getPsi()).getNode();
            this.myParsedFromRepository = new PatchedSoftReference<CompositeElement>(parsed2);
            assert (parsed2 != null);
            return parsed2;
        }
        catch (IncorrectOperationException e) {
            LOG.error("Bad annotation in repository!", e);
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiAnnotationStub[").append(this.myText).append("]");
        return builder.toString();
    }
}

