/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.java.stubs.PsiClassInitializerStub;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.PsiImportListStub;
import com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterStub;
import com.intellij.psi.impl.java.stubs.StubPsiFactory;
import com.intellij.psi.impl.source.PsiAnnotationMethodImpl;
import com.intellij.psi.impl.source.PsiAnonymousClassImpl;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiClassInitializerImpl;
import com.intellij.psi.impl.source.PsiEnumConstantImpl;
import com.intellij.psi.impl.source.PsiEnumConstantInitializerImpl;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.impl.source.PsiImportListImpl;
import com.intellij.psi.impl.source.PsiImportStatementImpl;
import com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.PsiModifierListImpl;
import com.intellij.psi.impl.source.PsiParameterImpl;
import com.intellij.psi.impl.source.PsiParameterListImpl;
import com.intellij.psi.impl.source.PsiReferenceListImpl;
import com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl;
import com.intellij.psi.impl.source.tree.java.PsiTypeParameterExtendsBoundsListImpl;
import com.intellij.psi.impl.source.tree.java.PsiTypeParameterImpl;
import com.intellij.psi.impl.source.tree.java.PsiTypeParameterListImpl;
import com.intellij.psi.stubs.IStubElementType;

public class SourceStubPsiFactory
extends StubPsiFactory {
    @Override
    public PsiClass createClass(PsiClassStub stub) {
        if (stub.isEnumConstantInitializer()) {
            return new PsiEnumConstantInitializerImpl(stub);
        }
        if (stub.isAnonymous()) {
            return new PsiAnonymousClassImpl(stub);
        }
        return new PsiClassImpl(stub);
    }

    @Override
    public PsiAnnotation createAnnotation(PsiAnnotationStub stub) {
        return new PsiAnnotationImpl(stub);
    }

    @Override
    public PsiClassInitializer createClassInitializer(PsiClassInitializerStub stub) {
        return new PsiClassInitializerImpl(stub);
    }

    @Override
    public PsiReferenceList createClassReferenceList(PsiClassReferenceListStub stub) {
        if (stub.getRole() == PsiReferenceList.Role.EXTENDS_BOUNDS_LIST) {
            return new PsiTypeParameterExtendsBoundsListImpl(stub, (IStubElementType)JavaStubElementTypes.EXTENDS_BOUND_LIST);
        }
        return new PsiReferenceListImpl(stub, stub.getStubType());
    }

    @Override
    public PsiField createField(PsiFieldStub stub) {
        return stub.isEnumConstant() ? new PsiEnumConstantImpl(stub) : new PsiFieldImpl(stub);
    }

    @Override
    public PsiImportList createImportList(PsiImportListStub stub) {
        return new PsiImportListImpl(stub);
    }

    @Override
    public PsiImportStatementBase createImportStatement(PsiImportStatementStub stub) {
        if (stub.isStatic()) {
            return new PsiImportStaticStatementImpl(stub);
        }
        return new PsiImportStatementImpl(stub);
    }

    @Override
    public PsiMethod createMethod(PsiMethodStub stub) {
        return stub.isAnnotationMethod() ? new PsiAnnotationMethodImpl(stub) : new PsiMethodImpl(stub);
    }

    @Override
    public PsiModifierList createModifierList(PsiModifierListStub stub) {
        return new PsiModifierListImpl(stub);
    }

    @Override
    public PsiParameter createParameter(PsiParameterStub stub) {
        return new PsiParameterImpl(stub);
    }

    @Override
    public PsiParameterList createParameterList(PsiParameterListStub stub) {
        return new PsiParameterListImpl(stub);
    }

    @Override
    public PsiTypeParameter createTypeParameter(PsiTypeParameterStub stub) {
        return new PsiTypeParameterImpl(stub);
    }

    @Override
    public PsiTypeParameterList createTypeParameterList(PsiTypeParameterListStub stub) {
        return new PsiTypeParameterListImpl(stub);
    }
}

