/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lexer.JavaLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiModifierListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterListStubImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.io.StringRef;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class StubBuildingVisitor<T>
implements ClassVisitor {
    private static final Pattern REGEX_PATTERN = Pattern.compile("(?<=[^\\$])\\${1}(?=[^\\$])");
    public static final String DOUBLE_POSITIVE_INF = "1.0 / 0.0";
    public static final String DOUBLE_NEGATIVE_INF = "-1.0 / 0.0";
    public static final String DOUBLE_NAN = "0.0d / 0.0";
    public static final String FLOAT_POSITIVE_INF = "1.0f / 0.0";
    public static final String FLOAT_NEGATIVE_INF = "-1.0f / 0.0";
    public static final String FLOAT_NAN = "0.0f / 0.0";
    private final InnerClassSourceStrategy<T> myInnersStrategy;
    private final StubElement myParent;
    private final int myAccess;
    private final T mySource;
    private PsiModifierListStub myModList;
    private PsiClassStub myResult;
    @NonNls
    private static final String SYNTHETIC_CLINIT_METHOD = "<clinit>";
    @NonNls
    private static final String SYNTHETIC_INIT_METHOD = "<init>";
    private JavaLexer myLexer;

    public StubBuildingVisitor(T classSource, InnerClassSourceStrategy<T> innersStrategy, StubElement parent, int access) {
        this.mySource = classSource;
        this.myInnersStrategy = innersStrategy;
        this.myParent = parent;
        this.myAccess = access;
    }

    public PsiClassStub<?> getResult() {
        return this.myResult;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String convertedSuper;
        StringCharacterIterator signatureIterator;
        String fqn = StubBuildingVisitor.getClassName(name);
        String shortName = PsiNameHelper.getShortClassName(fqn);
        int flags = this.myAccess == 0 ? access : this.myAccess;
        boolean isDeprecated = (flags & 0x20000) != 0;
        boolean isInterface = (flags & 0x200) != 0;
        boolean isEnum = (flags & 0x4000) != 0;
        boolean isAnnotationType = (flags & 0x2000) != 0;
        byte stubFlags = PsiClassStubImpl.packFlags(isDeprecated, isInterface, isEnum, false, false, isAnnotationType, false, false);
        this.myResult = new PsiClassStubImpl(JavaStubElementTypes.CLASS, this.myParent, fqn, shortName, null, stubFlags);
        LanguageLevel languageLevel = StubBuildingVisitor.convertFromVersion(version);
        this.myLexer = new JavaLexer(languageLevel);
        ((PsiClassStubImpl)this.myResult).setLanguageLevel(languageLevel);
        this.myModList = new PsiModifierListStubImpl((StubElement)this.myResult, StubBuildingVisitor.packClassFlags(flags));
        StringCharacterIterator stringCharacterIterator = signatureIterator = signature != null ? new StringCharacterIterator(signature) : null;
        if (signatureIterator != null) {
            try {
                SignatureParsing.parseTypeParametersDeclaration(signatureIterator, this.myResult);
            }
            catch (ClsFormatException e) {
                signatureIterator = null;
            }
        } else {
            new PsiTypeParameterListStubImpl(this.myResult);
        }
        ArrayList<String> convertedInterfaces = new ArrayList<String>();
        if (signatureIterator == null) {
            convertedSuper = StubBuildingVisitor.parseClassDescription(superName, interfaces, convertedInterfaces);
        } else {
            try {
                convertedSuper = StubBuildingVisitor.parseClassSignature(signatureIterator, convertedInterfaces);
            }
            catch (ClsFormatException e) {
                new PsiTypeParameterListStubImpl(this.myResult);
                convertedSuper = StubBuildingVisitor.parseClassDescription(superName, interfaces, convertedInterfaces);
            }
        }
        String[] interfacesArray = ArrayUtil.toStringArray(convertedInterfaces);
        if (isInterface) {
            new PsiClassReferenceListStubImpl(JavaStubElementTypes.EXTENDS_LIST, (StubElement)this.myResult, interfacesArray, PsiReferenceList.Role.EXTENDS_LIST);
            new PsiClassReferenceListStubImpl(JavaStubElementTypes.IMPLEMENTS_LIST, (StubElement)this.myResult, ArrayUtil.EMPTY_STRING_ARRAY, PsiReferenceList.Role.IMPLEMENTS_LIST);
        } else {
            if (convertedSuper != null && !"java.lang.Object".equals(convertedSuper)) {
                new PsiClassReferenceListStubImpl(JavaStubElementTypes.EXTENDS_LIST, (StubElement)this.myResult, new String[]{convertedSuper}, PsiReferenceList.Role.EXTENDS_LIST);
            } else {
                new PsiClassReferenceListStubImpl(JavaStubElementTypes.EXTENDS_LIST, (StubElement)this.myResult, ArrayUtil.EMPTY_STRING_ARRAY, PsiReferenceList.Role.EXTENDS_LIST);
            }
            new PsiClassReferenceListStubImpl(JavaStubElementTypes.IMPLEMENTS_LIST, (StubElement)this.myResult, interfacesArray, PsiReferenceList.Role.IMPLEMENTS_LIST);
        }
    }

    @Nullable
    private static String parseClassDescription(String superName, String[] interfaces, List<String> convertedInterfaces) {
        String convertedSuper = superName != null ? StubBuildingVisitor.getClassName(superName) : null;
        for (String anInterface : interfaces) {
            convertedInterfaces.add(StubBuildingVisitor.getClassName(anInterface));
        }
        return convertedSuper;
    }

    @Nullable
    private static String parseClassSignature(CharacterIterator signatureIterator, List<String> convertedInterfaces) throws ClsFormatException {
        String convertedSuper = SignatureParsing.parseToplevelClassRefSignature(signatureIterator);
        while (signatureIterator.current() != '\uffff') {
            String ifs = SignatureParsing.parseToplevelClassRefSignature(signatureIterator);
            if (ifs == null) {
                throw new ClsFormatException();
            }
            convertedInterfaces.add(ifs);
        }
        return convertedSuper;
    }

    private static LanguageLevel convertFromVersion(int version) {
        if (version == 196653 || version == 46 || version == 47) {
            return LanguageLevel.JDK_1_3;
        }
        if (version == 48) {
            return LanguageLevel.JDK_1_4;
        }
        if (version == 49 || version == 50) {
            return LanguageLevel.JDK_1_5;
        }
        return LanguageLevel.HIGHEST;
    }

    private static int packCommonFlags(int access) {
        int flags = 0;
        flags = (access & 2) != 0 ? (flags |= 2) : ((access & 4) != 0 ? (flags |= 4) : ((access & 1) != 0 ? (flags |= 1) : (flags |= 0x1000)));
        if ((access & 8) != 0) {
            flags |= 8;
        }
        if ((access & 0x10) != 0) {
            flags |= 0x10;
        }
        return flags;
    }

    private static int packClassFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if ((access & 0x400) != 0) {
            flags |= 0x400;
        }
        return flags;
    }

    private static int packFieldFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if ((access & 0x40) != 0) {
            flags |= 0x40;
        }
        if ((access & 0x80) != 0) {
            flags |= 0x80;
        }
        return flags;
    }

    private static int packMethodFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if ((access & 0x20) != 0) {
            flags |= 0x20;
        }
        if ((access & 0x100) != 0) {
            flags |= 0x100;
        }
        if ((access & 0x400) != 0) {
            flags |= 0x400;
        }
        if ((access & 0x800) != 0) {
            flags |= 0x800;
        }
        return flags;
    }

    public void visitSource(String source, String debug) {
        ((PsiClassStubImpl)this.myResult).setSourceFileName(source);
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new AnnotationTextCollector(desc, new AnnotationResultCallback(){

            @Override
            public void callback(String text) {
                new PsiAnnotationStubImpl((StubElement)StubBuildingVisitor.this.myModList, text);
            }
        });
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if ((access & 0x1000) != 0) {
            return;
        }
        if (!this.isCorrectName(innerName)) {
            return;
        }
        if (innerName == null || outerName == null || !StubBuildingVisitor.getClassName(outerName).equals(this.myResult.getQualifiedName())) {
            return;
        }
        T innerSource = this.myInnersStrategy.findInnerClass(innerName, this.mySource);
        if (innerSource == null) {
            return;
        }
        ClassReader reader = this.myInnersStrategy.readerForInnerClass(innerSource);
        if (reader == null) {
            return;
        }
        StubBuildingVisitor<T> classVisitor = new StubBuildingVisitor<T>(innerSource, this.myInnersStrategy, this.myResult, access);
        reader.accept(classVisitor, 0);
    }

    private boolean isCorrectName(String name) {
        if (name == null) {
            return false;
        }
        this.myLexer.start(name);
        if (this.myLexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            return false;
        }
        this.myLexer.advance();
        return this.myLexer.getTokenType() == null;
    }

    @Nullable
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 0x1000) != 0) {
            return null;
        }
        if (!this.isCorrectName(name)) {
            return null;
        }
        byte flags = PsiFieldStubImpl.packFlags((access & 0x4000) != 0, (access & 0x20000) != 0, false);
        PsiFieldStubImpl stub = new PsiFieldStubImpl((StubElement)this.myResult, name, StubBuildingVisitor.fieldType(desc, signature), StubBuildingVisitor.constToString(value), flags);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, StubBuildingVisitor.packFieldFlags(access));
        return new AnnotationCollectingVisitor(stub, modList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static TypeInfo fieldType(String desc, String signature) {
        TypeInfo typeInfo;
        if (signature != null) {
            TypeInfo typeInfo2;
            try {
                typeInfo2 = TypeInfo.fromString(SignatureParsing.parseTypeString(new StringCharacterIterator(signature, 0)));
            }
            catch (ClsFormatException e) {
                typeInfo = StubBuildingVisitor.fieldTypeViaDescription(desc);
                if (typeInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/StubBuildingVisitor.fieldType must not return null");
                return typeInfo;
            }
            typeInfo = typeInfo2;
            if (typeInfo2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/StubBuildingVisitor.fieldType must not return null");
            return typeInfo;
        }
        typeInfo = StubBuildingVisitor.fieldTypeViaDescription(desc);
        if (typeInfo != null) return typeInfo;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/StubBuildingVisitor.fieldType must not return null");
    }

    @NotNull
    private static TypeInfo fieldTypeViaDescription(String desc) {
        int dim;
        Type type = Type.getType((String)desc);
        int n = dim = type.getSort() == 9 ? type.getDimensions() : 0;
        if (dim > 0) {
            type = type.getElementType();
        }
        TypeInfo typeInfo = new TypeInfo(StringRef.fromString(StubBuildingVisitor.getTypeText(type)), (byte)dim, false, Collections.<PsiAnnotationStub>emptyList());
        if (typeInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/StubBuildingVisitor.fieldTypeViaDescription must not return null");
        }
        return typeInfo;
    }

    @Nullable
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        int localVarIgnoreCount;
        String returnType;
        boolean isSynthetic;
        boolean bl = isSynthetic = (access & 0x1000) != 0;
        if (isSynthetic) {
            return null;
        }
        if (SYNTHETIC_CLINIT_METHOD.equals(name)) {
            return null;
        }
        boolean isDeprecated = (access & 0x20000) != 0;
        boolean isConstructor = SYNTHETIC_INIT_METHOD.equals(name);
        boolean isVarargs = (access & 0x80) != 0;
        boolean isAnnotationMethod = this.myResult.isAnnotationType();
        if (!isConstructor && !this.isCorrectName(name)) {
            return null;
        }
        byte flags = PsiMethodStubImpl.packFlags(isConstructor, isAnnotationMethod, isVarargs, isDeprecated, false);
        String canonicalMethodName = isConstructor ? this.myResult.getName() : name;
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> throwables = exceptions != null ? new ArrayList<String>() : null;
        PsiMethodStubImpl stub = new PsiMethodStubImpl(this.myResult, StringRef.fromString(canonicalMethodName), flags, null);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, StubBuildingVisitor.packMethodFlags(access));
        boolean parsedViaGenericSignature = false;
        if (signature == null) {
            returnType = StubBuildingVisitor.parseMethodViaDescription(desc, stub, args);
        } else {
            try {
                returnType = StubBuildingVisitor.parseMethodViaGenericSignature(signature, stub, args, throwables);
                parsedViaGenericSignature = true;
            }
            catch (ClsFormatException e) {
                returnType = StubBuildingVisitor.parseMethodViaDescription(desc, stub, args);
            }
        }
        stub.setReturnType(TypeInfo.fromString(returnType));
        boolean isNonStaticInnerClassConstructor = isConstructor && !(this.myParent instanceof PsiFileStub) && (this.myModList.getModifiersMask() & 8) == 0;
        boolean shouldSkipFirstParamForNonStaticInnerClassConstructor = !parsedViaGenericSignature && isNonStaticInnerClassConstructor;
        PsiParameterListStubImpl parameterList = new PsiParameterListStubImpl(stub);
        int paramCount = args.size();
        PsiParameterStubImpl[] paramStubs = new PsiParameterStubImpl[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            PsiParameterStubImpl parameterStub;
            if (shouldSkipFirstParamForNonStaticInnerClassConstructor && i == 0) continue;
            String arg = (String)args.get(i);
            boolean isEllipsisParam = isVarargs && i == paramCount - 1;
            TypeInfo typeInfo = TypeInfo.fromString(arg, isEllipsisParam);
            paramStubs[i] = parameterStub = new PsiParameterStubImpl((StubElement)parameterList, "p" + (i + 1), typeInfo, isEllipsisParam);
            new PsiModifierListStubImpl((StubElement)parameterStub, 0);
        }
        String[] thrownTypes = StubBuildingVisitor.buildThrowsList(exceptions, throwables, parsedViaGenericSignature);
        new PsiClassReferenceListStubImpl(JavaStubElementTypes.THROWS_LIST, (StubElement)stub, thrownTypes, PsiReferenceList.Role.THROWS_LIST);
        boolean isEnumConstructor = isConstructor && this.myResult.isEnum();
        int n = localVarIgnoreCount = (access & 8) != 0 ? 0 : 1;
        if (isEnumConstructor) {
            localVarIgnoreCount += 2;
        }
        int paramIgnoreCount = isEnumConstructor ? 2 : (isNonStaticInnerClassConstructor ? 1 : 0);
        return new AnnotationParamCollectingVisitor(stub, modList, localVarIgnoreCount, paramIgnoreCount, paramCount, paramStubs);
    }

    private static String[] buildThrowsList(String[] exceptions, List<String> throwables, boolean parsedViaGenericSignature) {
        if (exceptions == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (parsedViaGenericSignature && throwables != null && exceptions.length > throwables.size()) {
            parsedViaGenericSignature = false;
        }
        if (parsedViaGenericSignature && throwables != null) {
            return ArrayUtil.toStringArray(throwables);
        }
        String[] converted = ArrayUtil.newStringArray(exceptions.length);
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = StubBuildingVisitor.getClassName(exceptions[i]);
        }
        return converted;
    }

    private static String parseMethodViaDescription(String desc, PsiMethodStubImpl stub, List<String> args) {
        Type[] argTypes;
        String returnType = StubBuildingVisitor.getTypeText(Type.getReturnType((String)desc));
        for (Type argType : argTypes = Type.getArgumentTypes((String)desc)) {
            args.add(StubBuildingVisitor.getTypeText(argType));
        }
        new PsiTypeParameterListStubImpl(stub);
        return returnType;
    }

    private static String parseMethodViaGenericSignature(String signature, PsiMethodStubImpl stub, List<String> args, List<String> throwables) throws ClsFormatException {
        StringCharacterIterator iterator = new StringCharacterIterator(signature);
        SignatureParsing.parseTypeParametersDeclaration(iterator, stub);
        if (iterator.current() != '(') {
            throw new ClsFormatException();
        }
        iterator.next();
        while (iterator.current() != ')' && iterator.current() != '\uffff') {
            args.add(SignatureParsing.parseTypeString(iterator));
        }
        if (iterator.current() != ')') {
            throw new ClsFormatException();
        }
        iterator.next();
        String returnType = SignatureParsing.parseTypeString(iterator);
        while (iterator.current() == '^') {
            iterator.next();
            throwables.add(SignatureParsing.parseTypeString(iterator));
        }
        return returnType;
    }

    public void visitEnd() {
    }

    @Nullable
    private static String constToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return "\"" + StringUtil.escapeStringCharacters((String)value) + "\"";
        }
        if (value instanceof Integer || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Long) {
            return value.toString() + "L";
        }
        if (value instanceof Double) {
            double d = (Double)value;
            if (Double.isInfinite(d)) {
                return d > 0.0 ? DOUBLE_POSITIVE_INF : DOUBLE_NEGATIVE_INF;
            }
            if (Double.isNaN(d)) {
                return DOUBLE_NAN;
            }
            return Double.toString(d);
        }
        if (value instanceof Float) {
            float v = ((Float)value).floatValue();
            if (Float.isInfinite(v)) {
                return v > 0.0f ? FLOAT_POSITIVE_INF : FLOAT_NEGATIVE_INF;
            }
            if (Float.isNaN(v)) {
                return FLOAT_NAN;
            }
            return Float.toString(v) + "f";
        }
        return null;
    }

    private static String getClassName(String name) {
        return StubBuildingVisitor.getTypeText(Type.getObjectType((String)name));
    }

    private static String getTypeText(Type type) {
        String raw = type.getClassName();
        return raw.contains("$") ? REGEX_PATTERN.matcher(raw).replaceAll("\\.") : raw;
    }

    private static interface AnnotationResultCallback {
        public void callback(String var1);
    }

    private static class AnnotationParamCollectingVisitor
    extends AnnotationCollectingVisitor {
        private final int myIgnoreCount;
        private final int myParamIgnoreCount;
        private final int myParamCount;
        private final PsiParameterStubImpl[] myParamStubs;
        private int myUsedParamSize = 0;
        private int myUsedParamCount = 0;

        private AnnotationParamCollectingVisitor(PsiMethodStub owner, PsiModifierListStub modList, int ignoreCount, int paramIgnoreCount, int paramCount, PsiParameterStubImpl[] paramStubs) {
            super(owner, modList);
            this.myIgnoreCount = ignoreCount;
            this.myParamIgnoreCount = paramIgnoreCount;
            this.myParamCount = paramCount;
            this.myParamStubs = paramStubs;
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (index >= this.myIgnoreCount) {
                int paramIndex;
                int n = paramIndex = index - this.myIgnoreCount == this.myUsedParamSize ? this.myUsedParamCount : index - this.myIgnoreCount;
                if (paramIndex >= this.myParamCount) {
                    return;
                }
                PsiParameterStubImpl parameterStub = this.myParamStubs[paramIndex];
                if (parameterStub != null) {
                    parameterStub.setName(name);
                }
                this.myUsedParamCount = paramIndex + 1;
                this.myUsedParamSize = "D".equals(desc) || "J".equals(desc) ? (this.myUsedParamSize += 2) : ++this.myUsedParamSize;
            }
        }

        @Override
        @Nullable
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return parameter < this.myParamIgnoreCount ? null : super.visitParameterAnnotation(parameter - this.myParamIgnoreCount, desc, visible);
        }
    }

    private static class AnnotationCollectingVisitor
    extends EmptyVisitor {
        private final StubElement myOwner;
        private final PsiModifierListStub myModList;

        private AnnotationCollectingVisitor(StubElement owner, PsiModifierListStub modList) {
            this.myOwner = owner;
            this.myModList = modList;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationTextCollector(null, new AnnotationResultCallback(){

                @Override
                public void callback(String text) {
                    ((PsiMethodStubImpl)AnnotationCollectingVisitor.this.myOwner).setDefaultValueText(text);
                }
            });
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, new AnnotationResultCallback(){

                @Override
                public void callback(String text) {
                    new PsiAnnotationStubImpl((StubElement)AnnotationCollectingVisitor.this.myModList, text);
                }
            });
        }

        @Nullable
        public AnnotationVisitor visitParameterAnnotation(final int parameter, String desc, boolean visible) {
            return new AnnotationTextCollector(desc, new AnnotationResultCallback(){

                @Override
                public void callback(String text) {
                    new PsiAnnotationStubImpl((StubElement)((PsiMethodStub)AnnotationCollectingVisitor.this.myOwner).findParameter(parameter).getModList(), text);
                }
            });
        }
    }

    private static class AnnotationTextCollector
    implements AnnotationVisitor {
        private final StringBuilder myBuilder = new StringBuilder();
        private final AnnotationResultCallback myCallback;
        private boolean hasParams = false;
        private final String myDesc;

        public AnnotationTextCollector(@Nullable String desc, AnnotationResultCallback callback) {
            this.myCallback = callback;
            this.myDesc = desc;
            if (desc != null) {
                this.myBuilder.append('@').append(StubBuildingVisitor.getTypeText(Type.getType((String)desc)));
            }
        }

        public void visit(String name, Object value) {
            this.valuePairPrefix(name);
            this.myBuilder.append(StubBuildingVisitor.constToString(value));
        }

        public void visitEnum(String name, String desc, String value) {
            this.valuePairPrefix(name);
            this.myBuilder.append(StubBuildingVisitor.getTypeText(Type.getType((String)desc))).append(".").append(value);
        }

        private void valuePairPrefix(String name) {
            if (!this.hasParams) {
                this.hasParams = true;
                if (this.myDesc != null) {
                    this.myBuilder.append('(');
                }
            } else {
                this.myBuilder.append(',');
            }
            if (name != null && !"value".equals(name)) {
                this.myBuilder.append(name).append('=');
            }
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.valuePairPrefix(name);
            return new AnnotationTextCollector(desc, new AnnotationResultCallback(){

                @Override
                public void callback(String text) {
                    AnnotationTextCollector.this.myBuilder.append(text);
                }
            });
        }

        public AnnotationVisitor visitArray(String name) {
            this.valuePairPrefix(name);
            this.myBuilder.append("{");
            return new AnnotationTextCollector(null, new AnnotationResultCallback(){

                @Override
                public void callback(String text) {
                    AnnotationTextCollector.this.myBuilder.append(text).append('}');
                }
            });
        }

        public void visitEnd() {
            if (this.hasParams && this.myDesc != null) {
                this.myBuilder.append(')');
            }
            this.myCallback.callback(this.myBuilder.toString());
        }
    }
}

