/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.compiled.ClsStubBuilderFactory;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.cls.ClsFormatException;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;

public class DefaultClsStubBuilderFactory
extends ClsStubBuilderFactory {
    public PsiFileStub buildFileStub(VirtualFile vFile, byte[] bytes) throws ClsFormatException {
        PsiJavaFileStubImpl file = new PsiJavaFileStubImpl("do.not.know.yet", true);
        try {
            ClassReader reader = new ClassReader(bytes);
            StubBuildingVisitor<VirtualFile> classVisitor = new StubBuildingVisitor<VirtualFile>(vFile, VirtualFileInnerClassStrategy.INSTANCE, file, 0);
            reader.accept(classVisitor, 0);
            PsiClassStub<PsiClass> result = classVisitor.getResult();
            if (result == null) {
                return null;
            }
            file.setPackageName(DefaultClsStubBuilderFactory.getPackageName(result));
        }
        catch (Exception e) {
            throw new ClsFormatException();
        }
        return file;
    }

    @Override
    public boolean canBeProcessed(VirtualFile file, byte[] bytes) {
        return true;
    }

    @Override
    public boolean isInnerClass(VirtualFile file) {
        return DefaultClsStubBuilderFactory.isInner(file.getNameWithoutExtension(), new ParentDirectory(file));
    }

    static boolean isInner(String name, Directory directory) {
        return DefaultClsStubBuilderFactory.isInner(name, 0, directory);
    }

    private static boolean isInner(String name, int from, Directory directory) {
        int index = name.indexOf(36, from);
        return index != -1 && (DefaultClsStubBuilderFactory.containsPart(directory, name, index) || DefaultClsStubBuilderFactory.isInner(name, index + 1, directory));
    }

    private static boolean containsPart(Directory directory, String name, int endIndex) {
        return endIndex > 0 && directory.contains(name.substring(0, endIndex));
    }

    private static String getPackageName(PsiClassStub<PsiClass> result) {
        String fqn = result.getQualifiedName();
        String shortName = result.getName();
        if (fqn == null || Comparing.equal(shortName, fqn)) {
            return "";
        }
        return fqn.substring(0, fqn.lastIndexOf(46));
    }

    private static class VirtualFileInnerClassStrategy
    implements InnerClassSourceStrategy<VirtualFile> {
        public static VirtualFileInnerClassStrategy INSTANCE = new VirtualFileInnerClassStrategy();

        private VirtualFileInnerClassStrategy() {
        }

        @Override
        @Nullable
        public VirtualFile findInnerClass(String innerName, VirtualFile outerClass) {
            String baseName = outerClass.getNameWithoutExtension();
            VirtualFile dir = outerClass.getParent();
            assert (dir != null);
            return dir.findChild(baseName + "$" + innerName + ".class");
        }

        @Override
        @Nullable
        public ClassReader readerForInnerClass(VirtualFile innerClass) {
            try {
                return new ClassReader(innerClass.contentsToByteArray());
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private static class ParentDirectory
    implements Directory {
        private final VirtualFile myDirectory;
        private final String myExtension;

        private ParentDirectory(VirtualFile file) {
            this.myDirectory = file.getParent();
            this.myExtension = file.getExtension();
        }

        @Override
        public boolean contains(String name) {
            String fullName = this.myExtension == null ? name : name + "." + this.myExtension;
            return this.myDirectory != null && this.myDirectory.findChild(fullName) != null;
        }
    }

    static interface Directory {
        public boolean contains(String var1);
    }
}

