/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.compiled.ClsTypeParameterImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

public class ClsTypeParametersListImpl
extends ClsRepositoryPsiElement<PsiTypeParameterListStub>
implements PsiTypeParameterList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsTypeParametersListImpl");

    public ClsTypeParametersListImpl(PsiTypeParameterListStub stub) {
        super(stub);
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        PsiTypeParameter[] params = this.getTypeParameters();
        if (params.length != 0) {
            buffer.append('<');
            for (int i = 0; i < params.length; ++i) {
                ClsTypeParameterImpl parameter = (ClsTypeParameterImpl)params[i];
                if (i > 0) {
                    buffer.append(", ");
                }
                parameter.appendMirrorText(indentLevel, buffer);
            }
            buffer.append("> ");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsTypeParametersListImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiTypeParameter[] parms = this.getTypeParameters();
        PsiTypeParameter[] parmMirrors = ((PsiTypeParameterList)SourceTreeToPsiMap.treeElementToPsi(element)).getTypeParameters();
        LOG.assertTrue(parms.length == parmMirrors.length);
        if (parms.length == parmMirrors.length) {
            for (int i = 0; i < parms.length; ++i) {
                ((ClsElementImpl)((Object)parms[i])).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(parmMirrors[i]));
            }
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsTypeParametersListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiTypeParameter[] getTypeParameters() {
        return (PsiTypeParameter[])((PsiTypeParameterListStub)this.getStub()).getChildrenByType(JavaStubElementTypes.TYPE_PARAMETER, PsiTypeParameter.ARRAY_FACTORY);
    }

    @Override
    public int getTypeParameterIndex(PsiTypeParameter typeParameter) {
        LOG.assertTrue(typeParameter.getParent() == this);
        return PsiImplUtil.getTypeParameterIndex(typeParameter, this);
    }

    @Override
    public String toString() {
        return "PsiTypeParameterList";
    }
}

