/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsTypeElementImpl
extends ClsElementImpl
implements PsiTypeElement {
    public static final ClsTypeElementImpl[] EMPTY_ARRAY = new ClsTypeElementImpl[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsTypeImpl");
    static final char VARIANCE_NONE = '\u0000';
    static final char VARIANCE_EXTENDS = '+';
    static final char VARIANCE_SUPER = '-';
    static final char VARIANCE_INVARIANT = '*';
    private final PsiElement myParent;
    private final String myTypeText;
    private volatile ClsElementImpl myChild = null;
    private boolean myChildSet = false;
    private volatile PsiType myCachedType;
    private final char myVariance;
    @NonNls
    private static final String VARIANCE_EXTENDS_PREFIX = "? extends ";
    @NonNls
    private static final String VARIANCE_SUPER_PREFIX = "? super ";

    public ClsTypeElementImpl(PsiElement parent, String typeText, char variance) {
        this.myParent = parent;
        this.myTypeText = typeText;
        this.myVariance = variance;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        this.loadChild();
        if (this.myChild == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsTypeElementImpl.getChildren must not return null");
            return psiElementArray;
        }
        psiElementArray = new PsiElement[]{this.myChild};
        if (psiElementArray != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsTypeElementImpl.getChildren must not return null");
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        String shortClassName = PsiNameHelper.getShortClassName(this.myTypeText);
        return this.decorateTypeText(shortClassName);
    }

    private String decorateTypeText(String shortClassName) {
        switch (this.myVariance) {
            case '\u0000': {
                return shortClassName;
            }
            case '+': {
                return VARIANCE_EXTENDS_PREFIX + shortClassName;
            }
            case '-': {
                return VARIANCE_SUPER_PREFIX + shortClassName;
            }
            case '*': {
                return "?";
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    public String getCanonicalText() {
        return this.decorateTypeText(this.myTypeText);
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        buffer.append(this.decorateTypeText(this.myTypeText));
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsTypeElementImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, JavaElementType.TYPE);
        this.loadChild();
        if (this.myChild != null) {
            this.myChild.setMirror(element.getFirstChildNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadChild() {
        if (this.isPrimitive()) {
            Object object = LAZY_BUILT_LOCK;
            synchronized (object) {
                this.myChildSet = true;
            }
            return;
        }
        if (this.isArray() || this.isVarArgs()) {
            this.createComponentTypeChild();
        } else {
            this.createClassReferenceChild();
        }
    }

    private boolean isPrimitive() {
        return JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createPrimitiveType(this.myTypeText) != null;
    }

    private boolean isArray() {
        return this.myTypeText.endsWith("[]");
    }

    private boolean isVarArgs() {
        return this.myTypeText.endsWith("...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiType getType() {
        if (this.myCachedType == null) {
            Object object = LAZY_BUILT_LOCK;
            synchronized (object) {
                if (this.myCachedType == null) {
                    this.myCachedType = this.calculateType();
                }
            }
        }
        PsiType psiType = this.myCachedType;
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsTypeElementImpl.getType must not return null");
        }
        return psiType;
    }

    @Override
    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        return null;
    }

    @Override
    public PsiAnnotationOwner getOwner(PsiAnnotation annotation) {
        return this;
    }

    @Override
    public PsiType getTypeNoResolve(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsTypeElementImpl.getTypeNoResolve must not be null");
        }
        return this.getType();
    }

    private PsiType calculateType() {
        PsiPrimitiveType result = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createPrimitiveType(this.myTypeText);
        if (result != null) {
            return result;
        }
        if (this.isArray()) {
            this.createComponentTypeChild();
            if (this.myVariance == '\u0000') {
                return ((PsiTypeElement)((Object)this.myChild)).getType().createArrayType();
            }
            switch (this.myVariance) {
                case '+': {
                    return PsiWildcardType.createExtends(this.getManager(), ((PsiTypeElement)((Object)this.myChild)).getType());
                }
                case '-': {
                    return PsiWildcardType.createSuper(this.getManager(), ((PsiTypeElement)((Object)this.myChild)).getType());
                }
            }
            LOG.assertTrue(false);
            return null;
        }
        if (this.isVarArgs()) {
            this.createComponentTypeChild();
            return new PsiEllipsisType(((PsiTypeElement)((Object)this.myChild)).getType());
        }
        this.createClassReferenceChild();
        PsiClassReferenceType psiClassReferenceType = this.myVariance != '*' ? new PsiClassReferenceType((PsiJavaCodeReferenceElement)((Object)this.myChild), null) : null;
        switch (this.myVariance) {
            case '\u0000': {
                return psiClassReferenceType;
            }
            case '+': {
                return PsiWildcardType.createExtends(this.getManager(), psiClassReferenceType);
            }
            case '-': {
                return PsiWildcardType.createSuper(this.getManager(), psiClassReferenceType);
            }
            case '*': {
                return PsiWildcardType.createUnbounded(this.getManager());
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClassReferenceChild() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (!this.myChildSet) {
                if (this.myVariance != '*') {
                    this.myChild = new ClsJavaCodeReferenceElementImpl(this, this.myTypeText);
                }
                this.myChildSet = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createComponentTypeChild() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (!this.myChildSet) {
                if (this.isArray()) {
                    this.myChild = this.myVariance == '\u0000' ? new ClsTypeElementImpl(this, this.myTypeText.substring(0, this.myTypeText.length() - 2), this.myVariance) : new ClsTypeElementImpl(this, this.myTypeText, '\u0000');
                } else if (this.isVarArgs()) {
                    this.myChild = new ClsTypeElementImpl(this, this.myTypeText.substring(0, this.myTypeText.length() - 3), this.myVariance);
                } else {
                    LOG.assertTrue(false);
                }
                this.myChildSet = true;
            }
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsTypeElementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsTypeElementImpl.findAnnotation must not be null");
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsTypeElementImpl.addAnnotation must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsTypeElementImpl.getApplicableAnnotations must not return null");
        }
        return psiAnnotationArray;
    }
}

