/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsParameterListImpl
extends ClsRepositoryPsiElement<PsiParameterListStub>
implements PsiParameterList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsParameterListImpl");

    public ClsParameterListImpl(PsiParameterListStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public PsiParameter[] getParameters() {
        PsiParameter[] psiParameterArray = (PsiParameter[])((PsiParameterListStub)this.getStub()).getChildrenByType(JavaStubElementTypes.PARAMETER, PsiParameter.ARRAY_FACTORY);
        if (psiParameterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterListImpl.getParameters must not return null");
        }
        return psiParameterArray;
    }

    @Override
    public int getParameterIndex(PsiParameter parameter) {
        LOG.assertTrue(parameter.getParent() == this);
        return PsiImplUtil.getParameterIndex(parameter, this);
    }

    @Override
    public int getParametersCount() {
        return this.getParameters().length;
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        buffer.append('(');
        PsiParameter[] parameters = this.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parm = parameters[i];
            if (i > 0) {
                buffer.append(", ");
            }
            ((ClsElementImpl)((Object)parm)).appendMirrorText(indentLevel, buffer);
        }
        buffer.append(')');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterListImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiParameter[] parms = this.getParameters();
        PsiParameter[] parmMirrors = ((PsiParameterList)SourceTreeToPsiMap.treeElementToPsi(element)).getParameters();
        LOG.assertTrue(parms.length == parmMirrors.length);
        if (parms.length == parmMirrors.length) {
            for (int i = 0; i < parms.length; ++i) {
                ((ClsElementImpl)((Object)parms[i])).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree(parmMirrors[i]));
            }
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiParameterList";
    }
}

