/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

class ClsPackageStatementImpl
extends ClsElementImpl
implements PsiPackageStatement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsPackageStatementImpl");
    private final ClsFileImpl myFile;
    private final String myPackageName;

    public ClsPackageStatementImpl(@NotNull ClsFileImpl file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsPackageStatementImpl.<init> must not be null");
        }
        this.myFile = file;
        PsiClass[] psiClasses = file.getClasses();
        String className = psiClasses.length > 0 ? psiClasses[0].getQualifiedName() : "";
        int index = className.lastIndexOf(46);
        this.myPackageName = index < 0 ? null : className.substring(0, index);
    }

    @Override
    public PsiElement getParent() {
        return this.myFile;
    }

    @Override
    public PsiJavaCodeReferenceElement getPackageReference() {
        LOG.error("method not implemented");
        return null;
    }

    @Override
    public PsiModifierList getAnnotationList() {
        LOG.error("method not implemented");
        return null;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        LOG.error("method not implemented");
        if (null == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsPackageStatementImpl.getChildren must not return null");
        }
        return null;
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        buffer.append("package ");
        buffer.append(this.getPackageName());
        buffer.append(";");
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsPackageStatementImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, ElementType.PACKAGE_STATEMENT);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsPackageStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPackageStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiPackageStatement:" + this.getPackageName();
    }
}

