/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.PsiModifierListImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsModifierListImpl
extends ClsRepositoryPsiElement<PsiModifierListStub>
implements PsiModifierList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClsModifierListImpl");

    public ClsModifierListImpl(PsiModifierListStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getAnnotations();
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsModifierListImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.hasModifierProperty must not be null");
        }
        int flag = PsiModifierListImpl.NAME_TO_MODIFIER_FLAG_MAP.get((Object)name);
        assert (flag != 0);
        return (((PsiModifierListStub)this.getStub()).getModifiersMask() & flag) != 0;
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.hasExplicitModifier must not be null");
        }
        return this.hasModifierProperty(name);
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.setModifierProperty must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.checkSetModifierProperty must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])((PsiModifierListStub)this.getStub()).getChildrenByType(JavaStubElementTypes.ANNOTATION, PsiAnnotation.ARRAY_FACTORY);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsModifierListImpl.getAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsModifierListImpl.getApplicableAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.findAnnotation must not be null");
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.addAnnotation must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    private boolean isAnnotationFormattingAllowed() {
        PsiElement element = this.getParent();
        return element instanceof PsiClass || element instanceof PsiMethod || element instanceof PsiField;
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuilder buffer) {
        boolean isInterfaceField;
        PsiAnnotation[] annotations = this.getAnnotations();
        boolean formattingAllowed = this.isAnnotationFormattingAllowed();
        for (PsiAnnotation annotation : annotations) {
            ((ClsAnnotationImpl)annotation).appendMirrorText(indentLevel, buffer);
            if (formattingAllowed) {
                ClsModifierListImpl.goNextLine(indentLevel, buffer);
                continue;
            }
            buffer.append(' ');
        }
        PsiElement parent = this.getParent();
        boolean isClass = parent instanceof PsiClass;
        boolean isInterface = isClass && ((PsiClass)parent).isInterface();
        boolean isInterfaceClass = isClass && parent.getParent() instanceof PsiClass && ((PsiClass)parent.getParent()).isInterface();
        boolean isMethod = parent instanceof PsiMethod;
        boolean isInterfaceMethod = isMethod && parent.getParent() instanceof PsiClass && ((PsiClass)parent.getParent()).isInterface();
        boolean isField = parent instanceof PsiField;
        boolean bl = isInterfaceField = isField && parent.getParent() instanceof PsiClass && ((PsiClass)parent.getParent()).isInterface();
        if (this.hasModifierProperty("public") && !isInterfaceMethod && !isInterfaceField && !isInterfaceClass) {
            buffer.append("public");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("protected")) {
            buffer.append("protected");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("private")) {
            buffer.append("private");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("static") && !isInterfaceField) {
            buffer.append("static");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("abstract") && !isInterface && !isInterfaceMethod) {
            buffer.append("abstract");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("final") && !isInterfaceField) {
            buffer.append("final");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("native")) {
            buffer.append("native");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("synchronized")) {
            buffer.append("synchronized");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("transient")) {
            buffer.append("transient");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("volatile")) {
            buffer.append("volatile");
            buffer.append(' ');
        }
        if (this.hasModifierProperty("strictfp")) {
            buffer.append("strictfp");
            buffer.append(' ');
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, JavaElementType.MODIFIER_LIST);
        PsiAnnotation[] mirrorAnnotations = ((PsiModifierList)SourceTreeToPsiMap.treeToPsiNotNull(element)).getAnnotations();
        PsiAnnotation[] annotations = this.getAnnotations();
        LOG.assertTrue(annotations.length == mirrorAnnotations.length);
        for (int i = 0; i < annotations.length; ++i) {
            ((ClsElementImpl)((Object)annotations[i])).setMirror(SourceTreeToPsiMap.psiToTreeNotNull(mirrorAnnotations[i]));
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsModifierListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiModifierList";
    }
}

