/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.ide.caches.FileContent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.io.IOException;

public class CacheUtil {
    public static final Key<Boolean> CACHE_COPY_KEY = new Key("CACHE_COPY_KEY");
    private static final Key<CharSequence> CONTENT_KEY = new Key("CONTENT_KEY");

    private CacheUtil() {
    }

    public static boolean isCopy(PsiFile psiFile) {
        return psiFile.getUserData(CACHE_COPY_KEY) != null;
    }

    public static PsiFile createFileCopy(FileContent content, PsiFile psiFile) {
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null) {
            return psiFile;
        }
        if (psiFile instanceof PsiFileEx) {
            return ((PsiFileEx)psiFile).cacheCopy(content);
        }
        return psiFile;
    }

    public static CharSequence getContentText(FileContent content) {
        Document doc = FileDocumentManager.getInstance().getCachedDocument(content.getVirtualFile());
        if (doc != null) {
            return doc.getCharsSequence();
        }
        CharSequence cached = content.getUserData(CONTENT_KEY);
        if (cached != null) {
            return cached;
        }
        try {
            cached = LoadTextUtil.getTextByBinaryPresentation(content.getBytes(), content.getVirtualFile(), false);
            cached = content.putUserDataIfAbsent(CONTENT_KEY, cached);
            return cached;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static boolean isInComments(IElementType tokenType) {
        TokenSet commentTokens;
        Language language = tokenType.getLanguage();
        boolean inComments = false;
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition != null && (commentTokens = parserDefinition.getCommentTokens()).contains(tokenType)) {
            inComments = true;
        }
        return inComments;
    }
}

