/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import gnu.trove.TObjectIntHashMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class RecordUtil {
    @NonNls
    private static final String DEPRECATED_ANNOTATION_NAME = "Deprecated";
    @NonNls
    private static final String DEPRECATED_TAG = "@deprecated";
    private static final TObjectIntHashMap<String> ourModifierNameToFlagMap;
    private static final Set<String>[] SET_INSTANCES;
    private static final String[] VISIBILITY_MODIFIERS;
    private static final int[] MODIFIER_MAP;

    private RecordUtil() {
    }

    public static boolean isDeprecatedByAnnotation(PsiElement element) {
        PsiModifierList modifierList;
        if (element instanceof PsiModifierListOwner && (modifierList = ((PsiModifierListOwner)element).getModifierList()) != null) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
                PsiJavaCodeReferenceElement nameElement = annotation.getNameReferenceElement();
                if (nameElement == null || !DEPRECATED_ANNOTATION_NAME.equals(nameElement.getReferenceName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDeprecatedByAnnotation(LighterAST tree, LighterASTNode modList) {
        for (LighterASTNode child : tree.getChildren(modList)) {
            String name;
            LighterASTNode id;
            LighterASTNode ref;
            if (child.getTokenType() != JavaElementType.ANNOTATION || (ref = LightTreeUtil.firstChildOfType(tree, child, JavaElementType.JAVA_CODE_REFERENCE)) == null || (id = LightTreeUtil.firstChildOfType(tree, ref, JavaTokenType.IDENTIFIER)) == null || !DEPRECATED_ANNOTATION_NAME.equals(name = RecordUtil.intern(tree.getCharTable(), id))) continue;
            return true;
        }
        return false;
    }

    public static int packModifierList(LighterAST tree, LighterASTNode modList, StubElement parent) {
        int packed = 0;
        boolean alreadyPublic = false;
        boolean alreadyStatic = false;
        boolean alreadyFinal = false;
        boolean alreadyAbstract = false;
        LighterASTNode modListOwner = tree.getParent(modList);
        if (modListOwner != null && modListOwner.getTokenType() == parent.getStubType()) {
            StubElement grandParent = parent.getParentStub();
            if (parent instanceof PsiClassStub) {
                if (grandParent instanceof PsiClassStub && ((PsiClassStub)grandParent).isInterface()) {
                    alreadyPublic = true;
                    alreadyStatic = true;
                }
                if (((PsiClassStub)parent).isInterface()) {
                    alreadyAbstract = true;
                    alreadyStatic = grandParent instanceof PsiClassStub;
                }
                if (((PsiClassStub)parent).isEnum()) {
                    alreadyStatic = !(grandParent instanceof PsiFileStub);
                    alreadyFinal = true;
                    List<LighterASTNode> enumConstants = LightTreeUtil.getChildrenOfType(tree, modListOwner, JavaElementType.ENUM_CONSTANT);
                    for (LighterASTNode constant : enumConstants) {
                        if (LightTreeUtil.firstChildOfType(tree, constant, JavaElementType.ENUM_CONSTANT_INITIALIZER) == null) continue;
                        alreadyFinal = false;
                        break;
                    }
                    alreadyAbstract = false;
                    List<LighterASTNode> methods = LightTreeUtil.getChildrenOfType(tree, modListOwner, JavaElementType.METHOD);
                    for (LighterASTNode method : methods) {
                        LighterASTNode mods = LightTreeUtil.requiredChildOfType(tree, method, JavaElementType.MODIFIER_LIST);
                        if (LightTreeUtil.firstChildOfType(tree, mods, JavaTokenType.ABSTRACT_KEYWORD) == null) continue;
                        alreadyAbstract = true;
                        break;
                    }
                }
            } else if (parent instanceof PsiMethodStub) {
                if (grandParent instanceof PsiClassStub && ((PsiClassStub)grandParent).isInterface()) {
                    alreadyPublic = true;
                    alreadyAbstract = true;
                }
            } else if (parent instanceof PsiFieldStub) {
                if (parent.getStubType() == JavaElementType.ENUM_CONSTANT) {
                    alreadyPublic = true;
                    alreadyStatic = true;
                    alreadyFinal = true;
                } else if (grandParent instanceof PsiClassStub && ((PsiClassStub)grandParent).isInterface()) {
                    alreadyPublic = true;
                    alreadyStatic = true;
                    alreadyFinal = true;
                }
            }
        }
        for (LighterASTNode child : tree.getChildren(modList)) {
            IElementType type = child.getTokenType();
            if (type == JavaTokenType.PUBLIC_KEYWORD) {
                alreadyPublic = true;
                continue;
            }
            if (type == JavaTokenType.PRIVATE_KEYWORD) {
                packed |= 2;
                continue;
            }
            if (type == JavaTokenType.PROTECTED_KEYWORD) {
                packed |= 4;
                continue;
            }
            if (type == JavaTokenType.ABSTRACT_KEYWORD) {
                alreadyAbstract = true;
                continue;
            }
            if (type == JavaTokenType.FINAL_KEYWORD) {
                alreadyFinal = true;
                continue;
            }
            if (type == JavaTokenType.STATIC_KEYWORD) {
                alreadyStatic = true;
                continue;
            }
            if (type == JavaTokenType.NATIVE_KEYWORD) {
                packed |= 0x100;
                continue;
            }
            if (type == JavaTokenType.SYNCHRONIZED_KEYWORD) {
                packed |= 0x20;
                continue;
            }
            if (type == JavaTokenType.TRANSIENT_KEYWORD) {
                packed |= 0x80;
                continue;
            }
            if (type == JavaTokenType.VOLATILE_KEYWORD) {
                packed |= 0x40;
                continue;
            }
            if (type != JavaTokenType.STRICTFP_KEYWORD) continue;
            packed |= 0x800;
        }
        if (alreadyAbstract) {
            packed |= 0x400;
        }
        if (alreadyFinal) {
            packed |= 0x10;
        }
        if (alreadyPublic) {
            packed |= 1;
        }
        if (alreadyStatic) {
            packed |= 8;
        }
        if ((packed & 2) == 0 && (packed & 4) == 0 && (packed & 1) == 0) {
            packed |= 0x1000;
        }
        return packed;
    }

    public static boolean isDeprecatedByDocComment(LighterAST tree, LighterASTNode comment) {
        String text = LightTreeUtil.toFilteredString(tree, comment, null);
        return text != null && text.contains(DEPRECATED_TAG);
    }

    public static boolean hasModifierProperty(String psiModifier, int packed) {
        return (ourModifierNameToFlagMap.get((Object)psiModifier) & packed) != 0;
    }

    public static Set<String> getModifierSet(int modifiers) {
        assert ((modifiers & 0xFFFFFBE0) == 0);
        int visibilityModifierIndex = MODIFIER_MAP[modifiers & 7];
        int index = (modifiers >>> 3 & 3) + ((modifiers & 0x400) >>> 8);
        if (visibilityModifierIndex != -1) {
            return SET_INSTANCES[index + (visibilityModifierIndex << 3)];
        }
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        if ((modifiers & 1) != 0) {
            res.add("public");
        }
        if ((modifiers & 2) != 0) {
            res.add("private");
        }
        if ((modifiers & 4) != 0) {
            res.add("protected");
        }
        res.addAll(SET_INSTANCES[index]);
        return res;
    }

    public static String intern(CharTable table, LighterASTNode node) {
        assert (node instanceof LighterASTTokenNode);
        return ((Object)table.intern(((LighterASTTokenNode)node).getText())).toString();
    }

    static {
        int i;
        ourModifierNameToFlagMap = new TObjectIntHashMap();
        ourModifierNameToFlagMap.put((Object)"public", 1);
        ourModifierNameToFlagMap.put((Object)"protected", 4);
        ourModifierNameToFlagMap.put((Object)"private", 2);
        ourModifierNameToFlagMap.put((Object)"packageLocal", 4096);
        ourModifierNameToFlagMap.put((Object)"static", 8);
        ourModifierNameToFlagMap.put((Object)"abstract", 1024);
        ourModifierNameToFlagMap.put((Object)"final", 16);
        ourModifierNameToFlagMap.put((Object)"native", 256);
        ourModifierNameToFlagMap.put((Object)"synchronized", 32);
        ourModifierNameToFlagMap.put((Object)"transient", 128);
        ourModifierNameToFlagMap.put((Object)"volatile", 64);
        ourModifierNameToFlagMap.put((Object)"strictfp", 2048);
        ourModifierNameToFlagMap.put((Object)"interface", 512);
        ourModifierNameToFlagMap.put((Object)"deprecated", 8192);
        ourModifierNameToFlagMap.put((Object)"@Deprecated", 65536);
        ourModifierNameToFlagMap.put((Object)"enum", 16384);
        ourModifierNameToFlagMap.put((Object)"@", 32768);
        SET_INSTANCES = new Set[32];
        VISIBILITY_MODIFIERS = new String[]{null, "public", "private", "protected"};
        MODIFIER_MAP = new int[]{0, 1, 2, -1, 3, -1, -1, -1, -1};
        RecordUtil.SET_INSTANCES[0] = Collections.emptySet();
        for (i = 1; i < 4; ++i) {
            RecordUtil.SET_INSTANCES[i << 3] = Collections.singleton(VISIBILITY_MODIFIERS[i]);
        }
        for (i = 1; i < 8; ++i) {
            int attr = i << 3;
            Set<String> set = new LinkedHashSet<String>();
            if ((attr & 8) != 0) {
                set.add("static");
            }
            if ((attr & 0x10) != 0) {
                set.add("final");
            }
            if ((attr & 0x20) != 0) {
                set.add("abstract");
            }
            if (set.size() == 1) {
                set = Collections.singleton(set.iterator().next());
            }
            RecordUtil.SET_INSTANCES[i] = set;
            for (int k = 1; k < 4; ++k) {
                LinkedHashSet<String> setWithModifier = new LinkedHashSet<String>();
                setWithModifier.add(VISIBILITY_MODIFIERS[k]);
                setWithModifier.addAll(set);
                assert (setWithModifier.size() > 1);
                RecordUtil.SET_INSTANCES[(k << 3) + i] = setWithModifier;
            }
        }
    }
}

