/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileFactoryImpl
extends PsiFileFactory {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiFileFactoryImpl");
    private final PsiManager myManager;

    public PsiFileFactoryImpl(PsiManager manager) {
        this.myManager = manager;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text, long modificationStamp, boolean bl) {
        void physical;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        PsiFile psiFile = this.createFileFromText(name, fileType, text, modificationStamp, (boolean)physical, true);
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
        }
        return psiFile;
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        return this.createFileFromText(name, language, text, true, true);
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text, boolean physical, boolean markAsCopy) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        return this.createFileFromText(name, language, text, physical, markAsCopy, false);
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text, boolean physical, boolean markAsCopy, boolean noSizeLimit) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name, language, text);
        if (noSizeLimit) {
            SingleRootFileViewProvider.doNotCheckFileSizeLimit(virtualFile);
        }
        return this.trySetupPsiForFile(virtualFile, language, physical, markAsCopy);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text, long modificationStamp, boolean physical, boolean bl) {
        PsiFile psiFile;
        void markAsCopy;
        Language language;
        PsiFile file;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name, fileType, text, modificationStamp);
        if (fileType instanceof LanguageFileType && (file = this.trySetupPsiForFile(virtualFile, language = LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), virtualFile, this.myManager.getProject()), physical, (boolean)markAsCopy)) != null) {
            psiFile = file;
            if (psiFile == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
            return psiFile;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile, physical);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated(plainTextFile.getNode(), true);
        }
        if ((psiFile = plainTextFile) != null) return psiFile;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
    }

    @Nullable
    public PsiFile trySetupPsiForFile(LightVirtualFile virtualFile, Language language, boolean physical, boolean markAsCopy) {
        PsiFile psiFile;
        ParserDefinition parserDefinition;
        FileViewProvider viewProvider;
        FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory != null ? factory.createFileViewProvider(virtualFile, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile, physical);
        }
        if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language = viewProvider.getBaseLanguage())) != null && (psiFile = viewProvider.getPsi(language)) != null) {
            if (markAsCopy) {
                PsiFileFactoryImpl.markGenerated(psiFile);
            }
            return psiFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, Language language, @NotNull Language targetLanguage, @NotNull CharSequence text, long modificationStamp, boolean physical, boolean bl) {
        PsiFile psiFile;
        void markAsCopy;
        PsiFile psiFile2;
        FileViewProvider viewProvider;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (targetLanguage == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name, fileType, text, modificationStamp);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory != null ? factory.createFileViewProvider(virtualFile, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile, physical);
        }
        if (parserDefinition != null && (psiFile2 = viewProvider.getPsi(targetLanguage)) != null) {
            if (markAsCopy != false) {
                PsiFileFactoryImpl.markGenerated(psiFile2);
            }
            if ((psiFile = psiFile2) == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
            return psiFile;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile, physical);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated(plainTextFile.getNode(), true);
        }
        if ((psiFile = plainTextFile) != null) return psiFile;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
    }

    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        PsiFile psiFile = this.createFileFromText(name, fileType, text, LocalTimeCounter.currentTime(), false);
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
        }
        return psiFile;
    }

    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull String text) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(name);
        if (type.isBinary()) {
            throw new RuntimeException("Cannot create binary files from text: name " + name + ", file type " + type);
        }
        PsiFile psiFile = this.createFileFromText(name, type, (CharSequence)text);
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not return null");
        }
        return psiFile;
    }

    @Override
    public PsiFile createFileFromText(FileType fileType, String fileName, CharSequence chars, int startOffset, int endOffset) {
        LOG.assertTrue(!fileType.isBinary());
        CharSequence text = startOffset == 0 && endOffset == chars.length() ? chars : new CharSequenceSubSequence(chars, startOffset, endOffset);
        return this.createFileFromText(fileName, fileType, text);
    }

    @Override
    @Nullable
    public PsiFile createFileFromText(@NotNull CharSequence chars, @NotNull PsiFile original) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        if (original == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createFileFromText must not be null");
        }
        PsiFile file = this.createFileFromText(original.getName(), original.getLanguage(), chars, false, true);
        if (file != null) {
            file.putUserData(ORIGINAL_FILE, original);
        }
        return file;
    }

    @Nullable
    public PsiElement createElementFromText(@Nullable String text, @NotNull Language language, @NotNull IElementType type, @NotNull PsiElement context) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createElementFromText must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createElementFromText must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/PsiFileFactoryImpl.createElementFromText must not be null");
        }
        if (text == null) {
            return null;
        }
        DummyHolder result = DummyHolderFactory.createHolder(context.getManager(), language, context);
        FileElement holder = result.getTreeElement();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            throw new AssertionError((Object)("No parser definition for " + language));
        }
        Project project = context.getProject();
        Lexer lexer = parserDefinition.createLexer(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, holder, lexer, language, (CharSequence)text);
        ASTNode node = parserDefinition.createParser(project).parse(type, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiFileFactoryImpl.markGenerated(result);
        return node.getPsi();
    }

    public static void markGenerated(PsiElement element) {
        TreeElement node = (TreeElement)element.getNode();
        assert (node != null);
        node.acceptTree(new GeneratedMarkerVisitor());
    }
}

