/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameUtil {
    private static final Function<String, String> LOWERCASE_MAPPING = new Function<String, String>(){

        @Override
        public String fun(String s) {
            return s.toLowerCase();
        }
    };
    private static final int MAX_LENGTH = 40;

    private NameUtil() {
    }

    public static List<String> nameToWordsLowerCase(String name) {
        return ContainerUtil.map(NameUtil.nameToWords(name), LOWERCASE_MAPPING);
    }

    public static String[] nameToWords(String name) {
        ArrayList<String> array = new ArrayList<String>();
        int index = 0;
        while (index < name.length()) {
            int wordStart = index;
            int upperCaseCount = 0;
            int lowerCaseCount = 0;
            int digitCount = 0;
            int specialCount = 0;
            while (index < name.length()) {
                char c = name.charAt(index);
                if (Character.isDigit(c)) {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || specialCount > 0) break;
                    ++digitCount;
                } else if (Character.isUpperCase(c)) {
                    if (lowerCaseCount > 0 || digitCount > 0 || specialCount > 0) break;
                    ++upperCaseCount;
                } else if (Character.isLowerCase(c)) {
                    if (digitCount > 0 || specialCount > 0) break;
                    if (upperCaseCount > 1) {
                        --index;
                        break;
                    }
                    ++lowerCaseCount;
                } else {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || digitCount > 0) break;
                    ++specialCount;
                }
                ++index;
            }
            String word = name.substring(wordStart, index);
            array.add(word);
        }
        return ArrayUtil.toStringArray(array);
    }

    public static String buildRegexp(String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        return NameUtil.buildRegexp(pattern, exactPrefixLen, allowToUpper, allowToLower, false, false);
    }

    public static String buildRegexp(String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords, boolean forCompletion) {
        boolean endsWithSpace;
        int eol = pattern.indexOf(10);
        if (eol != -1) {
            pattern = pattern.substring(0, eol);
        }
        if (pattern.length() >= 40) {
            pattern = pattern.substring(0, 40);
        }
        StringBuilder buffer = new StringBuilder();
        boolean lastIsUppercase = false;
        boolean prevIsUppercase = false;
        boolean bl = endsWithSpace = !forCompletion && StringUtil.endsWithChar(pattern, ' ');
        if (!forCompletion) {
            pattern = pattern.trim();
        }
        if ((exactPrefixLen = Math.min(exactPrefixLen, pattern.length())) > 0) {
            char c = pattern.charAt(exactPrefixLen - 1);
            prevIsUppercase = Character.isUpperCase(c) || Character.isDigit(c);
        }
        for (int i = 0; i != exactPrefixLen; ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append("\\").append(c);
        }
        if (exactPrefixLen == 0) {
            buffer.append("_*");
        }
        boolean firstIdentifierLetter = exactPrefixLen == 0;
        for (int i = exactPrefixLen; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            lastIsUppercase = false;
            if (Character.isLetterOrDigit(c)) {
                prevIsUppercase = false;
                if (Character.isUpperCase(c) || Character.isDigit(c)) {
                    prevIsUppercase = true;
                    lastIsUppercase = true;
                    buffer.append('(');
                    if (!firstIdentifierLetter) {
                        buffer.append("[a-z\\s0-9\\$]*");
                    }
                    buffer.append(c);
                    if (allowToLower) {
                        buffer.append('|');
                        buffer.append(Character.toLowerCase(c));
                    }
                    if (!firstIdentifierLetter) {
                        buffer.append("|[A-Za-z\\s0-9\\$]*[_-]+[");
                        buffer.append(c);
                        buffer.append(Character.toLowerCase(c));
                        buffer.append("]");
                    }
                    buffer.append(')');
                } else if (Character.isLowerCase(c) && allowToUpper) {
                    buffer.append('[');
                    buffer.append(c);
                    buffer.append(Character.toUpperCase(c));
                    buffer.append(']');
                    if (lowerCaseWords) {
                        buffer.append("([a-z\\s0-9\\$]*[-_]+)?");
                    }
                } else {
                    buffer.append(c);
                }
                firstIdentifierLetter = false;
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == '.') {
                if (!firstIdentifierLetter) {
                    buffer.append("[a-z\\s0-9\\$]*\\.");
                } else {
                    buffer.append("\\.");
                }
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ' ') {
                buffer.append("([a-z\\s0-9\\$_-]*[\\ _-]+)+");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ':' || prevIsUppercase) {
                buffer.append("[A-Za-z\\s0-9\\$]*");
            }
            firstIdentifierLetter = true;
            buffer.append("\\").append(c);
        }
        if (!endsWithSpace) {
            buffer.append(".*");
        } else if (lastIsUppercase) {
            buffer.append("[a-z\\s0-9\\$]*");
        }
        return buffer.toString();
    }

    public static String[] splitNameIntoWords(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/NameUtil.splitNameIntoWords must not be null");
        }
        String[] underlineDelimited = name.split("_");
        ArrayList<String> result = new ArrayList<String>();
        for (String word : underlineDelimited) {
            NameUtil.addAllWords(word, result);
        }
        return ArrayUtil.toStringArray(result);
    }

    public static List<String> getSuggestionsByName(String name, String prefix, String suffix, boolean upperCaseStyle, boolean preferLongerNames, boolean isArray) {
        ArrayList<String> answer = new ArrayList<String>();
        String[] words = NameUtil.nameToWords(name);
        for (int step = 0; step < words.length; ++step) {
            int wordCount = preferLongerNames ? words.length - step : step + 1;
            String startWord = words[words.length - wordCount];
            char c = startWord.charAt(0);
            if (c == '_' || !Character.isJavaIdentifierStart(c)) continue;
            StringBuilder buffer = new StringBuilder();
            buffer.append(prefix);
            startWord = upperCaseStyle ? startWord.toUpperCase() : (prefix.length() == 0 || StringUtil.endsWithChar(prefix, '_') ? startWord.toLowerCase() : Character.toUpperCase(c) + startWord.substring(1));
            buffer.append(startWord);
            for (int i = words.length - wordCount + 1; i < words.length; ++i) {
                String word = words[i];
                String prevWord = words[i - 1];
                if (upperCaseStyle) {
                    word = word.toUpperCase();
                    if (prevWord.charAt(prevWord.length() - 1) != '_' && word.charAt(0) != '_') {
                        word = "_" + word;
                    }
                } else if (prevWord.charAt(prevWord.length() - 1) == '_') {
                    word = word.toLowerCase();
                }
                buffer.append(word);
            }
            String suggestion = buffer.toString();
            if (isArray) {
                suggestion = StringUtil.pluralize(suggestion);
                if (upperCaseStyle) {
                    suggestion = suggestion.toUpperCase();
                }
            }
            answer.add(suggestion + suffix);
        }
        return answer;
    }

    private static boolean isWordStart(char p) {
        return Character.isUpperCase(p) || Character.isDigit(p);
    }

    private static int nextWord(String text, int start) {
        int i;
        if (!Character.isLetterOrDigit(text.charAt(start))) {
            return start + 1;
        }
        for (i = start; i < text.length() && NameUtil.isWordStart(text.charAt(i)); ++i) {
        }
        if (i > start + 1) {
            if (i == text.length() || !Character.isLetterOrDigit(text.charAt(i))) {
                return i;
            }
            return i - 1;
        }
        while (i < text.length() && !NameUtil.isWordStart(text.charAt(i)) && Character.isLetterOrDigit(text.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static void addAllWords(String text, List<String> result) {
        int start = 0;
        while (start < text.length()) {
            int next = NameUtil.nextWord(text, start);
            result.add(text.substring(start, next));
            start = next;
        }
    }

    public static com.intellij.util.text.Matcher buildCompletionMatcher(String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        return NameUtil.buildMatcher(pattern, options);
    }

    public static com.intellij.util.text.Matcher buildMatcher(String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        return NameUtil.buildMatcher(pattern, options);
    }

    @Deprecated
    public static com.intellij.util.text.Matcher buildMatcher(String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords) {
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        return NameUtil.buildMatcher(pattern, options);
    }

    private static com.intellij.util.text.Matcher buildMatcher(String pattern, MatchingCaseSensitivity options) {
        return new MinusculeMatcher(pattern, options);
    }

    public static class MinusculeMatcher
    implements com.intellij.util.text.Matcher {
        public static final Function<Character, Boolean> BASE_SEPARATOR_FUNCTION = new Function<Character, Boolean>(){

            @Override
            public Boolean fun(Character character) {
                char c = character.charValue();
                return Character.isWhitespace(c) || c == '_' || c == '-';
            }
        };
        private final char[] myPattern;
        private final MatchingCaseSensitivity myOptions;
        private final Function<Character, Boolean> mySeparatorFunction;

        public MinusculeMatcher(String pattern, MatchingCaseSensitivity options) {
            this(pattern, options, BASE_SEPARATOR_FUNCTION);
        }

        public MinusculeMatcher(String pattern, MatchingCaseSensitivity options, Function<Character, Boolean> separatorFunction) {
            this.myOptions = options;
            this.myPattern = StringUtil.trimEnd(pattern, "* ").replaceAll(":", "\\*:").toCharArray();
            this.mySeparatorFunction = separatorFunction;
        }

        @Nullable
        private FList<TextRange> matchName(String name, int patternIndex, int nameIndex) {
            if (patternIndex == this.myPattern.length) {
                return FList.emptyList();
            }
            if (nameIndex == name.length()) {
                return null;
            }
            if ('.' == this.myPattern[patternIndex] && name.charAt(nameIndex) != '.') {
                return this.skipChars(name, patternIndex, nameIndex, false);
            }
            if ('*' == this.myPattern[patternIndex]) {
                return this.skipChars(name, patternIndex, nameIndex, true);
            }
            if (patternIndex == 0 && this.myOptions != MatchingCaseSensitivity.NONE && name.charAt(nameIndex) != this.myPattern[0]) {
                return null;
            }
            if (this.isWordSeparator(name.charAt(nameIndex))) {
                return this.skipSeparators(name, patternIndex, nameIndex);
            }
            if (StringUtil.toLowerCase(name.charAt(nameIndex)) != StringUtil.toLowerCase(this.myPattern[patternIndex])) {
                if (Character.isDigit(name.charAt(nameIndex)) || name.charAt(nameIndex) == '.' && name.indexOf(46, nameIndex + 1) > 0) {
                    return this.matchName(name, patternIndex, nameIndex + 1);
                }
                return null;
            }
            if (this.myOptions == MatchingCaseSensitivity.ALL && name.charAt(nameIndex) != this.myPattern[patternIndex]) {
                return null;
            }
            int nextStart = NameUtil.nextWord(name, nameIndex);
            boolean uppers = NameUtil.isWordStart(this.myPattern[patternIndex]);
            int i = 1;
            while (true) {
                if (patternIndex + i == this.myPattern.length) {
                    return FList.emptyList().prepend(TextRange.from(nameIndex, i));
                }
                if (i + nameIndex == nextStart) break;
                char p = this.myPattern[patternIndex + i];
                if (uppers && NameUtil.isWordStart(p) && this.myOptions != MatchingCaseSensitivity.ALL) {
                    p = StringUtil.toLowerCase(p);
                } else {
                    uppers = false;
                }
                char w = name.charAt(i + nameIndex);
                if (this.myOptions != MatchingCaseSensitivity.ALL) {
                    w = StringUtil.toLowerCase(w);
                }
                if (w != p) break;
                ++i;
            }
            if (this.myPattern[patternIndex + i] == '*') {
                nextStart = nameIndex + i;
            }
            if (nextStart == name.length()) {
                char last;
                if (patternIndex + i == this.myPattern.length - 1 && (' ' == (last = this.myPattern[patternIndex + i]) && (i == 1 && NameUtil.isWordStart(this.myPattern[patternIndex]) || i + nameIndex == name.length()) || '*' == last)) {
                    return FList.emptyList().prepend(TextRange.from(nameIndex, i));
                }
                return null;
            }
            while (i > 0) {
                FList<TextRange> ranges = this.matchName(name, patternIndex + i, nextStart);
                if (ranges != null) {
                    return MinusculeMatcher.prependRange(ranges, nameIndex, i);
                }
                --i;
            }
            return null;
        }

        private static FList<TextRange> prependRange(FList<TextRange> ranges, int from, int length) {
            TextRange head = ranges.getHead();
            if (head != null && head.getStartOffset() == from + length) {
                return ranges.getTail().prepend(new TextRange(from, head.getEndOffset()));
            }
            return ranges.prepend(TextRange.from(from, length));
        }

        private boolean isWordSeparator(char c) {
            return this.mySeparatorFunction.fun(Character.valueOf(c));
        }

        @Nullable
        private FList<TextRange> skipSeparators(String name, int patternIndex, int nameIndex) {
            int nextStart = NameUtil.nextWord(name, nameIndex);
            assert (nextStart - nameIndex == 1) : "'" + name + "'" + nameIndex + " " + nextStart;
            char p = this.myPattern[patternIndex];
            if (this.isWordSeparator(p)) {
                if (this.myOptions != MatchingCaseSensitivity.NONE && nameIndex == 0 && name.length() > 1 && patternIndex + 1 < this.myPattern.length && this.isWordSeparator(name.charAt(1)) && !this.isWordSeparator(this.myPattern[patternIndex + 1])) {
                    return null;
                }
                FList<TextRange> ranges = this.matchName(name, patternIndex + 1, nextStart);
                if (ranges != null) {
                    return MinusculeMatcher.prependRange(ranges, nameIndex, 1);
                }
                return null;
            }
            return this.matchName(name, patternIndex, nextStart);
        }

        @Nullable
        private FList<TextRange> skipChars(String name, int patternIndex, int nameIndex, boolean maySkipNextChar) {
            int next;
            while ('*' == this.myPattern[patternIndex]) {
                if (++patternIndex != this.myPattern.length) continue;
                return FList.emptyList();
            }
            String nextChar = String.valueOf(this.myPattern[patternIndex]);
            boolean upper = Character.isUpperCase(this.myPattern[patternIndex]);
            int fromIndex = nameIndex;
            while ((next = StringUtil.indexOfIgnoreCase(name, nextChar, fromIndex)) >= 0) {
                if (upper && next > 0 && !Character.isUpperCase(name.charAt(next))) {
                    fromIndex = next + 1;
                    continue;
                }
                FList<TextRange> ranges = this.matchName(name, patternIndex, next);
                if (ranges != null) {
                    return ranges;
                }
                if (!maySkipNextChar) {
                    return null;
                }
                fromIndex = next + 1;
            }
            return null;
        }

        public int matchingDegree(String name) {
            Iterable<TextRange> iterable = this.matchingFragments(name);
            if (iterable == null) {
                return Integer.MIN_VALUE;
            }
            int matchingCaps = 0;
            int fragmentCount = 0;
            for (TextRange range : iterable) {
                matchingCaps += StringUtil.capitalsOnly(name.substring(range.getStartOffset(), range.getEndOffset())).length();
                ++fragmentCount;
            }
            int patternCaps = StringUtil.capitalsOnly(new String(this.myPattern)).length();
            return -fragmentCount - Math.max(0, patternCaps - matchingCaps) * 10;
        }

        @Override
        public boolean matches(String name) {
            return this.matchingFragments(name) != null;
        }

        @Nullable
        public Iterable<TextRange> matchingFragments(String name) {
            if (name.isEmpty()) {
                return this.myPattern.length == 0 ? Collections.emptyList() : null;
            }
            return this.matchName(name, 0, 0);
        }
    }

    public static enum MatchingCaseSensitivity {
        NONE,
        FIRST_LETTER,
        ALL;

    }

    public static interface Matcher {
        public boolean matches(String var1);
    }
}

