/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.augment;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PsiAugmentProvider {
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create("com.intellij.lang.psiAugmentProvider");

    @NotNull
    public abstract <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement var1, @NotNull Class<Psi> var2);

    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/augment/PsiAugmentProvider.collectAugments must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/augment/PsiAugmentProvider.collectAugments must not be null");
        }
        ArrayList<Psi> augments = new ArrayList<Psi>();
        for (PsiAugmentProvider provider : Extensions.getExtensions(EP_NAME)) {
            try {
                List<Psi> list = provider.getAugments(element, type);
                augments.addAll(list);
            }
            catch (ProcessCanceledException ignore) {
                // empty catch block
            }
        }
        ArrayList<Psi> arrayList = augments;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/augment/PsiAugmentProvider.collectAugments must not return null");
        }
        return arrayList;
    }
}

