/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiType
implements PsiAnnotationOwner {
    public static final PsiPrimitiveType BYTE = new PsiPrimitiveType("byte", "java.lang.Byte");
    public static final PsiPrimitiveType CHAR = new PsiPrimitiveType("char", "java.lang.Character");
    public static final PsiPrimitiveType DOUBLE = new PsiPrimitiveType("double", "java.lang.Double");
    public static final PsiPrimitiveType FLOAT = new PsiPrimitiveType("float", "java.lang.Float");
    public static final PsiPrimitiveType INT = new PsiPrimitiveType("int", "java.lang.Integer");
    public static final PsiPrimitiveType LONG = new PsiPrimitiveType("long", "java.lang.Long");
    public static final PsiPrimitiveType SHORT = new PsiPrimitiveType("short", "java.lang.Short");
    public static final PsiPrimitiveType BOOLEAN = new PsiPrimitiveType("boolean", "java.lang.Boolean");
    public static final PsiPrimitiveType VOID = new PsiPrimitiveType("void", "java.lang.Void");
    public static final PsiPrimitiveType NULL = new PsiPrimitiveType("null", (String)null);
    public static final PsiType[] EMPTY_ARRAY = new PsiType[0];
    private final PsiAnnotation[] myAnnotations;

    protected PsiType(@NotNull PsiAnnotation[] annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiType.<init> must not be null");
        }
        this.myAnnotations = annotations;
    }

    @NotNull
    public PsiArrayType createArrayType() {
        PsiArrayType psiArrayType = new PsiArrayType(this);
        if (psiArrayType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiType.createArrayType must not return null");
        }
        return psiArrayType;
    }

    @NotNull
    public PsiArrayType createArrayType(PsiAnnotation ... annotations) {
        PsiArrayType psiArrayType = new PsiArrayType(this, annotations);
        if (psiArrayType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiType.createArrayType must not return null");
        }
        return psiArrayType;
    }

    public abstract String getPresentableText();

    @NonNls
    public abstract String getCanonicalText();

    public abstract String getInternalCanonicalText();

    public abstract boolean isValid();

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiType.isAssignableFrom must not be null");
        }
        return TypeConversionUtil.isAssignable(this, type);
    }

    public boolean isConvertibleFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiType.isConvertibleFrom must not be null");
        }
        return TypeConversionUtil.areTypesConvertible(type, this);
    }

    public abstract boolean equalsToText(@NonNls String var1);

    @NotNull
    public static PsiClassType getJavaLangObject(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiType.getJavaLangObject must not be null");
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiType.getJavaLangObject must not be null");
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Object", resolveScope);
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiType.getJavaLangObject must not return null");
        }
        return psiClassType;
    }

    public static PsiClassType getJavaLangClass(PsiManager manager, GlobalSearchScope resolveScope) {
        return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Class", resolveScope);
    }

    public static PsiClassType getJavaLangTrowable(PsiManager manager, GlobalSearchScope resolveScope) {
        return PsiType.getJavaLangThrowable(manager, resolveScope);
    }

    public static PsiClassType getJavaLangThrowable(PsiManager manager, GlobalSearchScope resolveScope) {
        return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Throwable", resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangString(PsiManager manager, GlobalSearchScope resolveScope) {
        PsiClassType psiClassType = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.String", resolveScope);
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiType.getJavaLangString must not return null");
        }
        return psiClassType;
    }

    public static PsiClassType getJavaLangError(PsiManager manager, GlobalSearchScope resolveScope) {
        return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Error", resolveScope);
    }

    public static PsiClassType getJavaLangRuntimeException(PsiManager manager, GlobalSearchScope resolveScope) {
        return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.RuntimeException", resolveScope);
    }

    public abstract <A> A accept(PsiTypeVisitor<A> var1);

    public final int getArrayDimensions() {
        PsiType type = this;
        int dims = 0;
        while (type instanceof PsiArrayType) {
            ++dims;
            type = ((PsiArrayType)type).getComponentType();
        }
        return dims;
    }

    @NotNull
    public final PsiType getDeepComponentType() {
        PsiType type = this;
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        PsiType psiType = type;
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiType.getDeepComponentType must not return null");
        }
        return psiType;
    }

    @Nullable
    public abstract GlobalSearchScope getResolveScope();

    public String toString() {
        return "PsiType:" + this.getPresentableText();
    }

    @NotNull
    public abstract PsiType[] getSuperTypes();

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        if (this.myAnnotations == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiType.getAnnotations must not return null");
        }
        return this.myAnnotations;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiType.findAnnotation must not be null");
        }
        return null;
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiType.addAnnotation must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiType.getApplicableAnnotations must not return null");
        }
        return psiAnnotationArray;
    }

    protected String getAnnotationsTextPrefix() {
        PsiAnnotation[] annotations = this.getAnnotations();
        return StringUtil.join(annotations, new Function<PsiAnnotation, String>(){

            @Override
            public String fun(PsiAnnotation annotation) {
                return "@" + annotation.getQualifiedName();
            }
        }, " ") + (annotations.length == 0 ? "" : " ");
    }
}

